/*
 * Decompiled with CFR 0.152.
 */
package net.kautler.command.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import net.kautler.command.api.Command;
import net.kautler.command.usage.UsageLexer;
import net.kautler.command.usage.UsageParser;
import net.kautler.command.usage.UsagePatternBuilder;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

@ApplicationScoped
public class ParameterParser {
    @Inject
    private volatile UsagePatternBuilder usagePatternBuilder;
    private final Map<String, UsageParser.UsageContext> usageTreeCache = new ConcurrentHashMap<String, UsageParser.UsageContext>();

    private ParameterParser() {
    }

    public Map<String, String> getParsedParameters(Command<?> command, String prefix, String usedAlias, String parameterString) {
        Optional<String> optionalUsage = command.getUsage();
        if (optionalUsage.isPresent()) {
            String usage = optionalUsage.get();
            UsageParser.UsageContext usageTree = this.usageTreeCache.computeIfAbsent(usage, key -> {
                UsageLexer usageLexer = new UsageLexer((CharStream)CharStreams.fromString((String)usage));
                UsageParser usageParser = new UsageParser((TokenStream)new CommonTokenStream((TokenSource)usageLexer));
                return usageParser.usage();
            });
            Pattern usagePattern = this.usagePatternBuilder.getPattern(usageTree);
            Matcher parameterMatcher = usagePattern.matcher(parameterString.trim());
            if (parameterMatcher.matches()) {
                HashMap<String, String> result = new HashMap<String, String>();
                this.usagePatternBuilder.getGroupNamesByTokenName(usageTree).forEach((tokenName, groupNames) -> {
                    String tokenValue = groupNames.stream().map(parameterMatcher::group).filter(Objects::nonNull).collect(Collectors.joining(","));
                    if (!tokenValue.isEmpty()) {
                        result.put((String)tokenName, tokenValue);
                    }
                });
                return result;
            }
            throw new IllegalArgumentException(String.format("Wrong arguments for command `%s%s`\nUsage: `%1$s%2$s %s`", prefix, usedAlias, usage));
        }
        if (parameterString.chars().allMatch(Character::isWhitespace)) {
            return Collections.emptyMap();
        }
        throw new IllegalArgumentException(String.format("Command `%s%s` does not expect arguments", prefix, usedAlias));
    }

    public void fixupParsedParameter(Map<String, String> parameters, String placeholderName, String literalName) {
        if (!parameters.containsKey(literalName) && literalName.equals(parameters.get(placeholderName))) {
            parameters.put(literalName, literalName);
            parameters.remove(placeholderName);
        }
    }

    public String toString() {
        return new StringJoiner(", ", ParameterParser.class.getSimpleName() + "[", "]").add("usagePatternBuilder=" + this.usagePatternBuilder).add("usageTreeCache=" + this.usageTreeCache).toString();
    }
}

