/*
 * Decompiled with CFR 0.152.
 */
package net.kautler.command.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.kautler.command.InvalidAnnotationCombinationException;
import net.kautler.command.api.annotation.Alias;
import net.kautler.command.api.annotation.Asynchronous;
import net.kautler.command.api.annotation.Description;
import net.kautler.command.api.annotation.RestrictedTo;
import net.kautler.command.api.annotation.RestrictionPolicy;
import net.kautler.command.api.annotation.Usage;
import net.kautler.command.api.restriction.Everyone;
import net.kautler.command.api.restriction.RestrictionChainElement;

public interface Command<M> {
    public static final String PARAMETER_SEPARATOR_CHARACTER = "[\\s&&[^\\n]]";
    public static final Pattern PARAMETER_SEPARATOR_PATTERN = Pattern.compile("[\\s&&[^\\n]]++");

    default public List<String> getAliases() {
        Class<?> clazz = this.getClass();
        List<String> annotatedAliases = Arrays.stream((Alias[])clazz.getAnnotationsByType(Alias.class)).map(Alias::value).collect(Collectors.toList());
        if (!annotatedAliases.isEmpty()) {
            return annotatedAliases;
        }
        String className = clazz.getSimpleName();
        if (className.isEmpty()) {
            className = clazz.getTypeName().substring(clazz.getPackage().getName().length() + 1);
        }
        String defaultAlias = className.replaceAll("(?i)^(?:Command|Cmd)|(?:Command|Cmd)$", "");
        defaultAlias = defaultAlias.replaceFirst("^.", Character.toString(Character.toLowerCase(defaultAlias.charAt(0))));
        return Collections.singletonList(defaultAlias);
    }

    default public Optional<String> getDescription() {
        return Optional.ofNullable(this.getClass().getAnnotation(Description.class)).map(Description::value);
    }

    default public Optional<String> getUsage() {
        return Optional.ofNullable(this.getClass().getAnnotation(Usage.class)).map(Usage::value);
    }

    default public RestrictionChainElement getRestrictionChain() {
        List restrictions = Arrays.stream((RestrictedTo[])this.getClass().getAnnotationsByType(RestrictedTo.class)).map(RestrictedTo::value).collect(Collectors.toList());
        int restrictionsAmount = restrictions.size();
        if (restrictionsAmount == 0) {
            return new RestrictionChainElement(Everyone.class);
        }
        RestrictionPolicy restrictionPolicy = this.getClass().getAnnotation(RestrictionPolicy.class);
        if (restrictionsAmount == 1) {
            return restrictions.stream().map(RestrictionChainElement::new).map(restrictionChainElement -> restrictionPolicy != null && restrictionPolicy.value() == RestrictionPolicy.Policy.NONE_OF ? restrictionChainElement.negate() : restrictionChainElement).findAny().orElseThrow(AssertionError::new);
        }
        if (restrictionPolicy == null) {
            throw new InvalidAnnotationCombinationException(String.format("@RestrictionPolicy is mandatory if multiple @RestrictedTo annotations are given (%s)", this.getClass()));
        }
        switch (restrictionPolicy.value()) {
            case ALL_OF: {
                return restrictions.stream().map(RestrictionChainElement::new).reduce(RestrictionChainElement::and).orElseThrow(AssertionError::new);
            }
            case ANY_OF: {
                return restrictions.stream().map(RestrictionChainElement::new).reduce(RestrictionChainElement::or).orElseThrow(AssertionError::new);
            }
            case NONE_OF: {
                return restrictions.stream().map(RestrictionChainElement::new).reduce(RestrictionChainElement::or).orElseThrow(AssertionError::new).negate();
            }
        }
        throw new AssertionError((Object)String.format("Unhandled switch case for policy '%s'", new Object[]{restrictionPolicy.value()}));
    }

    default public boolean isAsynchronous() {
        return this.getClass().getAnnotation(Asynchronous.class) != null;
    }

    public void execute(M var1, String var2, String var3, String var4);

    public static String[] getParameters(String parameterString, int maxParameters) {
        if (parameterString.chars().allMatch(Character::isWhitespace)) {
            return new String[0];
        }
        return PARAMETER_SEPARATOR_PATTERN.split(parameterString, maxParameters);
    }
}

