/*
 * Decompiled with CFR 0.152.
 */
package net.kautler.command.usage;

import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import net.kautler.command.api.Command;
import net.kautler.command.usage.UsageBaseVisitor;
import net.kautler.command.usage.UsageParser;
import net.kautler.command.usage.UsageParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;

@ApplicationScoped
public class UsagePatternBuilder
extends UsageBaseVisitor<String> {
    private static final String PARAMETER_BOUNDARY_PATTERN_PART = String.format("(?:%s|$)", Command.PARAMETER_SEPARATOR_PATTERN.pattern());
    private final Map<UsageParser.UsageContext, Pattern> patternCache = new ConcurrentHashMap<UsageParser.UsageContext, Pattern>();
    private final Map<UsageParser.UsageContext, Map<String, List<String>>> groupNamesBySanitizedTokenNameByUsageContext = new ConcurrentHashMap<UsageParser.UsageContext, Map<String, List<String>>>();
    private final Map<UsageParser.UsageContext, Map<String, List<String>>> groupNamesByTokenNameByUsageContext = new ConcurrentHashMap<UsageParser.UsageContext, Map<String, List<String>>>();

    private UsagePatternBuilder() {
    }

    public Pattern getPattern(UsageParser.UsageContext usageTree) {
        return this.patternCache.computeIfAbsent(usageTree, key -> {
            Pattern result = Pattern.compile(this.visitUsage(usageTree));
            this.groupNamesBySanitizedTokenNameByUsageContext.remove((Object)usageTree);
            return result;
        });
    }

    public Map<String, List<String>> getGroupNamesByTokenName(UsageParser.UsageContext usageTree) {
        return this.groupNamesByTokenNameByUsageContext.computeIfAbsent(usageTree, key -> new ConcurrentHashMap());
    }

    @Override
    public String visitUsage(UsageParser.UsageContext ctx) {
        return this.visitParentParserRuleContext(ctx);
    }

    @Override
    public String visitAlternatives(UsageParser.AlternativesContext ctx) {
        return ctx.alternativesSubExpression().stream().map(this::visitParentParserRuleContext).collect(Collectors.joining("|", "(?:", ")"));
    }

    @Override
    public String visitOptional(UsageParser.OptionalContext ctx) {
        return String.format("(?:%s)?", this.visitParentParserRuleContext(ctx.optionalSubExpression()));
    }

    private String visitParentParserRuleContext(UsageParserRuleContext ctx) {
        boolean hasSingleChild;
        boolean bl = hasSingleChild = ctx.placeholder() != null || ctx.placeholderWithWhitespace() != null || ctx.literal() != null || ctx.optional() != null || ctx.alternatives() != null;
        if (hasSingleChild) {
            return (String)ctx.getChild(0).accept((ParseTreeVisitor)this);
        }
        List<UsageParser.ExpressionContext> expressions = ctx.expression();
        if (expressions.isEmpty()) {
            throw new AssertionError((Object)"Unhandled case");
        }
        boolean[] first = new boolean[]{true};
        boolean[] leftOptional = new boolean[]{false};
        boolean[] leftHasWhitespace = new boolean[]{false};
        return expressions.stream().map(this::visitParentParserRuleContext).collect(Collector.of(StringBuilder::new, (left, right) -> {
            boolean rightOptional = right.endsWith(")?");
            if (first[0]) {
                left.append((String)right);
                first[0] = false;
                leftHasWhitespace[0] = false;
            } else if (leftOptional[0] && !leftHasWhitespace[0]) {
                left.insert(left.length() - 2, PARAMETER_BOUNDARY_PATTERN_PART);
                left.append((String)right);
                leftHasWhitespace[0] = false;
            } else if (rightOptional) {
                left.append(right.replaceFirst("^\\(\\?(?::|<[^>]++>)", "$0" + Matcher.quoteReplacement(PARAMETER_BOUNDARY_PATTERN_PART)));
                leftHasWhitespace[0] = true;
            } else {
                left.append(PARAMETER_BOUNDARY_PATTERN_PART);
                left.append((String)right);
                leftHasWhitespace[0] = false;
            }
            leftOptional[0] = rightOptional;
        }, (left, right) -> {
            throw new UnsupportedOperationException();
        }, Object::toString, new Collector.Characteristics[0]));
    }

    @Override
    public String visitPlaceholder(UsageParser.PlaceholderContext ctx) {
        String tokenText = ctx.getText();
        String tokenName = tokenText.substring(1, tokenText.length() - 1);
        return String.format("(?<%s>\\S+)", this.getGroupName(ctx, tokenName));
    }

    @Override
    public String visitPlaceholderWithWhitespace(UsageParser.PlaceholderWithWhitespaceContext ctx) {
        String tokenText = ctx.getText();
        String tokenName = tokenText.substring(1, tokenText.length() - 4);
        return String.format("(?<%s>.+)", this.getGroupName(ctx, tokenName));
    }

    @Override
    public String visitLiteral(UsageParser.LiteralContext ctx) {
        String tokenText = ctx.getText();
        String tokenName = tokenText.substring(1, tokenText.length() - 1);
        return String.format("(?<%s>%s)", this.getGroupName(ctx, tokenName, "Literal"), Pattern.quote(tokenName));
    }

    private String getGroupName(UsageParserRuleContext ctx, String tokenName) {
        return this.getGroupName(ctx, tokenName, "");
    }

    private String getGroupName(UsageParserRuleContext ctx, String tokenName, String groupNameSuffix) {
        UsageParser.UsageContext usageContext = this.getUsageContext(ctx);
        String sanitizedTokenName = tokenName.replaceAll("\\P{Alnum}++", "") + groupNameSuffix;
        String[] groupName = new String[1];
        this.groupNamesBySanitizedTokenNameByUsageContext.computeIfAbsent(usageContext, key -> new ConcurrentHashMap()).compute(sanitizedTokenName, (key, value) -> {
            if (value == null) {
                value = new CopyOnWriteArrayList<String>();
            }
            groupName[0] = key + value.size();
            value.add(groupName[0]);
            return value;
        });
        this.groupNamesByTokenNameByUsageContext.computeIfAbsent(usageContext, key -> new ConcurrentHashMap()).computeIfAbsent(tokenName, key -> new CopyOnWriteArrayList()).add(groupName[0]);
        return groupName[0];
    }

    private UsageParser.UsageContext getUsageContext(UsageParserRuleContext ctx) {
        UsageParserRuleContext current = ctx;
        while (current.getParent() != null) {
            current = current.getParent();
        }
        return (UsageParser.UsageContext)current;
    }

    public String toString() {
        return new StringJoiner(", ", UsagePatternBuilder.class.getSimpleName() + "[", "]").add("patternCache=" + this.patternCache).add("groupNamesBySanitizedTokenNameByUsageContext=" + this.groupNamesBySanitizedTokenNameByUsageContext).add("groupNamesByTokenNameByUsageContext=" + this.groupNamesByTokenNameByUsageContext).toString();
    }
}

