/*
 * Decompiled with CFR 0.152.
 */
package net.kautler.command.restriction;

import java.util.Collection;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.kautler.command.api.restriction.Restriction;

public class RestrictionLookup<M> {
    private final Collection<Restriction<? super M>> restrictions = new CopyOnWriteArrayList<Restriction<? super M>>();
    private final Map<Class<?>, Restriction<? super M>> restrictionByClass = new ConcurrentHashMap();

    public void addAllRestrictions(Collection<Restriction<? super M>> restrictions) {
        this.restrictions.addAll(restrictions);
    }

    public Restriction<? super M> getRestriction(Class<?> restrictionClass) {
        return this.restrictionByClass.computeIfAbsent(restrictionClass, key -> this.restrictions.stream().filter(key::isInstance).findAny().orElse(null));
    }

    public String toString() {
        return new StringJoiner(", ", RestrictionLookup.class.getSimpleName() + "[", "]").add("restrictions=" + this.restrictions).add("restrictionByClass=" + this.restrictionByClass).toString();
    }
}

