/*
 * Decompiled with CFR 0.152.
 */
package net.kautler.command.handler;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import net.kautler.command.Internal;
import net.kautler.command.api.Command;
import net.kautler.command.api.CommandHandler;
import net.kautler.command.api.event.javacord.CommandNotAllowedEventJavacord;
import net.kautler.command.api.event.javacord.CommandNotFoundEventJavacord;
import net.kautler.command.api.prefix.PrefixProvider;
import net.kautler.command.api.restriction.Restriction;
import org.apache.logging.log4j.Logger;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.message.Message;
import org.javacord.api.event.message.MessageCreateEvent;
import org.javacord.api.util.logging.ExceptionLogger;

@ApplicationScoped
class CommandHandlerJavacord
extends CommandHandler<Message> {
    @Inject
    @Internal
    private volatile Logger logger;
    @Inject
    private volatile Instance<DiscordApi> discordApis;
    @Inject
    private volatile Instance<Collection<DiscordApi>> discordApiCollections;
    @Inject
    private volatile Event<CommandNotAllowedEventJavacord> commandNotAllowedEvent;
    @Inject
    private volatile Event<CommandNotFoundEventJavacord> commandNotFoundEvent;

    private CommandHandlerJavacord() {
    }

    @Inject
    private void setAvailableRestrictions(Instance<Restriction<? super Message>> availableRestrictions) {
        this.doSetAvailableRestrictions(availableRestrictions);
    }

    @Inject
    private void setCommands(Instance<Command<? super Message>> commands) {
        this.doSetCommands(commands);
    }

    @Inject
    private void setCustomPrefixProvider(Instance<PrefixProvider<? super Message>> customPrefixProvider) {
        this.doSetCustomPrefixProvider(customPrefixProvider);
    }

    @PostConstruct
    private void addListener() {
        if (this.discordApis.isUnsatisfied() && this.discordApiCollections.isUnsatisfied()) {
            this.logger.info("No DiscordApi or Collection<DiscordApi> injected, JavacordCommandHandler will not be used.");
        } else {
            if (this.discordApis.isUnsatisfied()) {
                this.logger.info("Collection<DiscordApi> injected, JavacordCommandHandler will be used.");
            } else if (this.discordApiCollections.isUnsatisfied()) {
                this.logger.info("DiscordApi injected, JavacordCommandHandler will be used.");
            } else {
                this.logger.info("DiscordApi and Collection<DiscordApi> injected, JavacordCommandHandler will be used.");
            }
            Stream.concat(this.discordApis.stream(), this.discordApiCollections.stream().flatMap(Collection::stream)).forEach(discordApi -> discordApi.addMessageCreateListener(this::handleMessage));
        }
    }

    private void handleMessage(MessageCreateEvent messageCreateEvent) {
        Message message = messageCreateEvent.getMessage();
        this.doHandleMessage(message, message.getContent());
    }

    @Override
    protected void fireCommandNotAllowedEvent(Message message, String prefix, String usedAlias) {
        this.commandNotAllowedEvent.fireAsync((Object)new CommandNotAllowedEventJavacord(message, prefix, usedAlias));
    }

    @Override
    protected void fireCommandNotFoundEvent(Message message, String prefix, String usedAlias) {
        this.commandNotFoundEvent.fireAsync((Object)new CommandNotFoundEventJavacord(message, prefix, usedAlias));
    }

    @Override
    protected void executeAsync(Message message, Runnable commandExecutor) {
        CompletableFuture.runAsync(commandExecutor, message.getApi().getThreadPool().getExecutorService()).exceptionally(ExceptionLogger.get((Class[])new Class[0]));
    }
}

