/*
 * Decompiled with CFR 0.152.
 */
package net.kautler.command.api.restriction.javacord;

import java.util.regex.Pattern;
import net.kautler.command.api.restriction.Restriction;
import org.javacord.api.entity.DiscordEntity;
import org.javacord.api.entity.Nameable;
import org.javacord.api.entity.message.Message;

public abstract class UserJavacord
implements Restriction<Message> {
    private final long userId;
    private final String userName;
    private final boolean caseSensitive;
    private final Pattern userPattern;

    protected UserJavacord(long userId) {
        this(userId, null, true, null);
    }

    protected UserJavacord(String userName) {
        this(0L, userName, true, null);
    }

    protected UserJavacord(String userName, boolean caseSensitive) {
        this(0L, userName, caseSensitive, null);
    }

    protected UserJavacord(Pattern userPattern) {
        this(0L, null, true, userPattern);
    }

    private UserJavacord(long userId, String userName, boolean caseSensitive, Pattern userPattern) {
        this.userId = userId;
        this.userName = userName;
        this.caseSensitive = caseSensitive;
        this.userPattern = userPattern;
    }

    @Override
    public boolean allowCommand(Message message) {
        return this.userName == null && this.userPattern == null ? this.allowCommandByUserId(message) : this.allowCommandByUserName(message);
    }

    private boolean allowCommandByUserId(Message message) {
        return message.getUserAuthor().map(DiscordEntity::getId).map(authorId -> authorId == this.userId).orElse(Boolean.FALSE);
    }

    private boolean allowCommandByUserName(Message message) {
        return message.getUserAuthor().map(Nameable::getName).map(authorName -> {
            if (this.userName == null) {
                return this.userPattern.matcher((CharSequence)authorName).matches();
            }
            if (this.caseSensitive) {
                return this.userName.equals(authorName);
            }
            return this.userName.equalsIgnoreCase((String)authorName);
        }).orElse(Boolean.FALSE);
    }
}

