/*
 * Decompiled with CFR 0.152.
 */
package net.kautler.command.api;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import net.kautler.command.Internal;
import net.kautler.command.api.Command;
import net.kautler.command.api.prefix.PrefixProvider;
import net.kautler.command.api.restriction.Restriction;
import net.kautler.command.restriction.RestrictionLookup;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public abstract class CommandHandler<M> {
    @Inject
    @Internal
    private volatile Logger logger;
    @Inject
    @Internal
    private volatile Instance<PrefixProvider<? super M>> defaultPrefixProvider;
    private final Map<String, Command<? super M>> commandByAlias = new ConcurrentHashMap<String, Command<? super M>>();
    private volatile Pattern commandPattern;
    private volatile Instance<PrefixProvider<? super M>> customPrefixProvider;
    private volatile PrefixProvider<? super M> prefixProvider;
    private final RestrictionLookup<M> availableRestrictions = new RestrictionLookup();
    private final Object executorServiceInitializationLock = new Object();
    private volatile ExecutorService executorService;

    private void ensureInitializationAtStartup(@Observes @Initialized(value=ApplicationScoped.class) Object event) {
    }

    protected void doSetAvailableRestrictions(Instance<Restriction<? super M>> availableRestrictions) {
        Collection restrictions = availableRestrictions.stream().peek(restriction -> this.logger.debug("Got restriction {} injected", new Supplier[]{() -> restriction.getClass().getName()})).collect(Collectors.toList());
        this.availableRestrictions.addAllRestrictions(restrictions);
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = restrictions::size;
        supplierArray[1] = () -> restrictions.size() == 1 ? "" : Character.valueOf('s');
        this.logger.info("Got {} restriction{} injected", supplierArray);
    }

    protected void doSetCommands(Instance<Command<? super M>> commands) {
        Collection actualCommands = commands.stream().peek(command -> this.logger.debug("Got command {} injected", new Supplier[]{() -> command.getClass().getName()})).collect(Collectors.toList());
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = actualCommands::size;
        supplierArray[1] = () -> actualCommands.size() == 1 ? "" : Character.valueOf('s');
        this.logger.info("Got {} command{} injected", supplierArray);
        actualCommands.forEach(Command::getRestrictionChain);
        this.commandByAlias.putAll(actualCommands.stream().flatMap(command -> command.getAliases().stream().map(alias -> new AbstractMap.SimpleImmutableEntry<String, Command>((String)alias, (Command)command))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (cmd1, cmd2) -> {
            throw new IllegalStateException(String.format("The same alias was defined for the two commands '%s' and '%s'", cmd1, cmd2));
        })));
        this.commandPattern = Pattern.compile(this.commandByAlias.keySet().stream().map(Pattern::quote).collect(Collectors.joining("|", "(?s)^(?<alias>", ")(?=\\s|$)[\\s&&[^\\n]]*+(?<parameterString>.*+)$")));
    }

    protected void doSetCustomPrefixProvider(Instance<PrefixProvider<? super M>> customPrefixProvider) {
        this.customPrefixProvider = customPrefixProvider;
    }

    @PostConstruct
    private void determinePrefixProvider() {
        this.prefixProvider = (PrefixProvider)(this.customPrefixProvider == null || this.customPrefixProvider.isUnsatisfied() ? this.defaultPrefixProvider : this.customPrefixProvider).get();
    }

    @PreDestroy
    private void shutdownExecutorService() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    protected void doHandleMessage(M message, String messageContent) {
        boolean emptyPrefix;
        String prefix = this.prefixProvider.getCommandPrefix(message);
        int prefixLength = prefix.length();
        boolean bl = emptyPrefix = prefixLength == 0;
        if (emptyPrefix) {
            this.logger.warn("The command prefix is empty, this means that every message will be checked against a regular expression and that for every non-matching message an event will be sent. It is better for the performance if you set a command prefix instead of including it in the aliases directly. If you do not care, just configure your logging framework to ignore this warning, as it also costs additional performance and might hide other important log messages. ;-)");
        }
        if (emptyPrefix || messageContent.startsWith(prefix)) {
            String messageContentWithoutPrefix = messageContent.substring(prefix.length()).trim();
            Matcher commandMatcher = Optional.ofNullable(this.commandPattern).orElseThrow(AssertionError::new).matcher(messageContentWithoutPrefix);
            if (commandMatcher.find()) {
                String usedAlias = commandMatcher.group("alias");
                Command command = this.commandByAlias.get(usedAlias);
                if (this.isCommandAllowed(message, command)) {
                    Runnable commandExecutor = () -> command.execute(message, prefix, usedAlias, commandMatcher.group("parameterString"));
                    if (command.isAsynchronous()) {
                        this.executeAsync(message, commandExecutor);
                    } else {
                        commandExecutor.run();
                    }
                } else {
                    this.logger.debug("Command {} was not allowed by restrictions", command);
                    this.fireCommandNotAllowedEvent(message, prefix, usedAlias);
                }
            } else {
                this.logger.debug("No matching command found");
                this.fireCommandNotFoundEvent(message, prefix, Command.getParameters(messageContentWithoutPrefix, 2)[0]);
            }
        }
    }

    private boolean isCommandAllowed(M message, Command<? super M> command) {
        return command.getRestrictionChain().isCommandAllowed(message, this.availableRestrictions);
    }

    protected abstract void fireCommandNotAllowedEvent(M var1, String var2, String var3);

    protected abstract void fireCommandNotFoundEvent(M var1, String var2, String var3);

    protected void executeAsync(M message, Runnable commandExecutor) {
        CompletableFuture.runAsync(commandExecutor, this.getExecutorService()).exceptionally(throwable -> {
            this.logger.error("Exception while executing command asynchronously", throwable);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getExecutorService() {
        ExecutorService executorService = this.executorService;
        if (executorService == null) {
            Object object = this.executorServiceInitializationLock;
            synchronized (object) {
                executorService = this.executorService;
                if (executorService == null) {
                    this.executorService = executorService = Executors.newCachedThreadPool();
                }
            }
        }
        return executorService;
    }
}

