/*
 * Copyright 2019 Björn Kautler
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.kautler.command.api.restriction;

/**
 * A restriction that checks allowance for usage of a command that was caused by a given message.
 *
 * @param <M> the class of the messages for which this restriction can check allowance
 */
public interface Restriction<M> {
    /**
     * Returns whether a command caused by the given message should be allowed by this restriction or not.
     *
     * @param message the message that caused the command to check allowance for
     * @return whether a command caused by the given message should be allowed by this restriction or not
     */
    boolean allowCommand(M message);
}
