/*
 * Copyright 2019 Björn Kautler
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.kautler.command;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;

/**
 * A CDI producer that produces log4j loggers for the bean class of the injection point.
 */
@ApplicationScoped
class LoggerProducer {
    /**
     * Constructs a new logger producer.
     */
    private LoggerProducer() {
    }

    /**
     * Returns a newly produced log4j logger for the bean class of the given injection point.
     *
     * @param injectionPoint the injection point for which to produce a log4j logger
     * @return a newly produced log4j logger for the bean class of the given injection point
     */
    @Produces
    @Internal
    private Logger getLogger(InjectionPoint injectionPoint) {
        return LogManager.getLogger(injectionPoint.getBean().getBeanClass());
    }
}
