/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.cli;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import net.kafujo.base.KafuException;
import net.kafujo.config.SystemProperty;
import net.kafujo.config.TypedReader;
import net.kafujo.container.RunnableResult;
import net.kafujo.io.KafuFile;
import net.kafujo.io.KafuInput;
import net.kafujo.units.KafuDuration;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CliApp
implements TypedReader {
    private Duration standardWaitDuration = Duration.ofMillis(Long.MAX_VALUE);
    private String appName = this.getClass().getSimpleName();
    protected final PrintStream out = System.out;
    protected final PrintStream err = System.err;
    private final String standardHelpOpt;
    private final String standardStatsOpt;
    private final String standardWaitOpt;
    private final boolean showHelpOnNoArgs;
    private final Map<String, RunnableResult<Boolean>> runnables = new HashMap<String, RunnableResult<Boolean>>();
    private final Options options = new Options();
    protected CommandLine commandLine = null;
    private RunnableResult<Boolean> throwOnExecute = () -> {
        throw new IllegalStateException("This is not supposed to be executed");
    };

    public CliApp() {
        this.standardHelpOpt = "?";
        this.standardStatsOpt = "S";
        this.standardWaitOpt = "W";
        this.showHelpOnNoArgs = true;
    }

    public CliApp(String standardHelpOpt, boolean showHelpOnNoArgs, String standardStatsOpt, String standardWaitOpt, Duration standardWaitDuration) {
        this.standardHelpOpt = standardHelpOpt;
        this.showHelpOnNoArgs = showHelpOnNoArgs;
        this.standardStatsOpt = standardStatsOpt;
        this.standardWaitOpt = standardWaitOpt;
        this.standardWaitDuration = standardWaitDuration;
    }

    protected final void addStandardOptions() {
        this.addStandardHelpOption();
        this.addStandardStatsOption();
        this.addStandardWaitOption();
    }

    protected void addStandardHelpOption() {
        this.addNoArgOption(this.throwOnExecute, this.standardHelpOpt, "*standard* help");
    }

    protected void addStandardStatsOption() {
        this.addNoArgOption(this.throwOnExecute, this.standardStatsOpt, "*standard* running statistics when done");
    }

    protected void addStandardWaitOption() {
        this.addOptionalArgOption(this.throwOnExecute, this.standardWaitOpt, "*standard* wait X millis to finish; default: " + this.standardWaitDuration);
    }

    void doHeader() {
    }

    void doStandardHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printUsage(new PrintWriter(this.out, true), 100, this.getClass().getName(), this.options);
        formatter.printHelp("options:", this.options);
    }

    protected boolean help() {
        return false;
    }

    private void addRunnable(String opt, RunnableResult<Boolean> code) {
        if (this.commandLine != null) {
            this.doStandardHelp();
            throw new IllegalStateException("Commandline already parsed, cannot add more options. ");
        }
        if (this.runnables.containsKey(opt)) {
            throw new IllegalStateException("option '" + opt + "' is already in use!");
        }
        this.runnables.put(opt, code);
    }

    protected void add(Option option) {
        this.options.addOption(option);
    }

    protected void add(RunnableResult<Boolean> code, Option option) {
        this.options.addOption(option);
        this.addRunnable(option.getOpt(), code);
    }

    protected void addNoArgOption(RunnableResult<Boolean> code, String opt, String description) {
        this.options.addOption(new Option(opt, false, description));
        this.addRunnable(opt, code);
    }

    protected void addArgOption(RunnableResult<Boolean> code, String opt, String description) {
        this.options.addOption(new Option(opt, true, description));
        this.addRunnable(opt, code);
    }

    protected void addOptionalArgOption(RunnableResult<Boolean> code, String opt, String description) {
        Option option = new Option(opt, description);
        option.setOptionalArg(true);
        option.setArgs(1);
        this.add(code, option);
    }

    public boolean isAvailable(CharSequence key) {
        if (!this.commandLine.hasOption(key.toString())) {
            return false;
        }
        String val = this.commandLine.getOptionValue(key.toString());
        return val != null && !val.isBlank();
    }

    public String readString(CharSequence key) {
        if (!this.isAvailable(key)) {
            throw new IllegalStateException("No option '" + key + "'");
        }
        return this.commandLine.getOptionValue(key.toString());
    }

    protected void run(String[] args) {
        if ((args == null || args.length == 0) && this.showHelpOnNoArgs) {
            this.doStandardHelp();
            return;
        }
        try {
            this.commandLine = new DefaultParser().parse(this.options, args);
        }
        catch (ParseException e) {
            this.out.println();
            this.out.println(KafuException.extractMessage((Throwable)e));
            this.out.println();
            this.doStandardHelp();
            return;
        }
        if (this.commandLine.hasOption(this.standardHelpOpt)) {
            this.doStandardHelp();
            return;
        }
        if (this.commandLine.hasOption(this.standardWaitOpt)) {
            this.standardWaitDuration = this.readDurationOfMillisFbk(this.standardWaitOpt, this.standardWaitDuration);
        }
        Instant start = Instant.now();
        for (String opt : this.runnables.keySet()) {
            if (!opt.equals(this.standardStatsOpt) && !opt.equals(this.standardWaitOpt) && this.commandLine.hasOption(opt) && !((Boolean)this.runnables.get(opt).execute()).booleanValue()) break;
        }
        if (this.commandLine.hasOption(this.standardStatsOpt)) {
            this.out.println("\n *** Running Time: " + KafuDuration.adaptUnits((Duration)Duration.between(start, Instant.now())));
        }
        if (this.commandLine.hasOption(this.standardWaitOpt)) {
            this.out.print("\n\n *** Wait " + KafuDuration.adaptUnits((Duration)this.standardWaitDuration) + " to finish; ");
            this.out.print("\n\n *** Wait till " + LocalDateTime.now().plus(this.standardWaitDuration) + " to finish; ");
            this.out.println(SystemProperty.JMXREMOTE_PORT);
            KafuDuration.sleep((Duration)this.standardWaitDuration);
            this.out.println(" *** TOTAL Running Time: " + KafuDuration.adaptUnits((Duration)Duration.between(start, Instant.now())));
        }
    }

    protected boolean confirmNextStep(String message) {
        this.out.print("\n    " + message + "       [Y]/[n]: ");
        String line = KafuInput.nextLine();
        if (line.isBlank() || line.equals("y") || line.equals("Y")) {
            this.out.println("\n       (: .... PROCESSING .... :)\n");
            return true;
        }
        this.out.println("\n       !!!!  ABORTED  !!!!\n");
        return false;
    }

    protected boolean confirmOverwrite(Path file) {
        if (Files.exists(file, new LinkOption[0])) {
            return this.confirmNextStep(file + " (" + KafuFile.sizeOfFile((Path)file) + ") will be overwitten");
        }
        return true;
    }
}

