/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.units;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KafuTime {
    public static final DateTimeFormatter USUSAL_TIME = DateTimeFormatter.ofPattern("hh:mm:ss");
    public static final DateTimeFormatter USUSAL_DATE = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter USUSAL_TIMESTAMP = DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss");
    private static final Logger lgr = LoggerFactory.getLogger(KafuTime.class);

    public static String ususal() {
        return KafuTime.ususal(LocalTime.now());
    }

    public static String ususal(Temporal time) {
        Objects.requireNonNull(time, "REQUIRE time to be formatted");
        return USUSAL_TIME.format(time);
    }

    public static String ususal(Temporal time, String def) {
        if (time == null) {
            lgr.debug("fall back to default '{}', cause time was null", (Object)def);
            return def;
        }
        try {
            return KafuTime.ususal(time);
        }
        catch (RuntimeException anyRt) {
            if (lgr.isDebugEnabled()) {
                lgr.debug("COULD NOT FORMAT '" + time + "' TO TIME", anyRt);
            } else {
                lgr.info("COULD NOT FORMAT '{}' TO TIME CAUSE {}", (Object)time, (Object)anyRt.toString());
            }
            return def;
        }
    }

    public static String ususalDate() {
        return KafuTime.ususalDate(LocalDate.now());
    }

    public static String ususalDate(Temporal date) {
        return USUSAL_DATE.format(date);
    }

    public static String ususalDate(Temporal date, String def) {
        if (date == null) {
            lgr.debug("fall back to default '{}', cause date was null", (Object)def);
            return def;
        }
        try {
            return KafuTime.ususalDate(date);
        }
        catch (RuntimeException anyRt) {
            if (lgr.isDebugEnabled()) {
                lgr.debug("COULD NOT FORMAT '" + date + "' TO DATE", anyRt);
            } else {
                lgr.info("COULD NOT FORMAT '{}' TO DATE CAUSE {}", (Object)date, (Object)anyRt.toString());
            }
            return def;
        }
    }
}

