/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.units;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.Random;
import net.kafujo.base.RequirementException;
import net.kafujo.units.DataSize;

public final class KafuNumber {
    private static final Random rand = new Random();
    public static final BigDecimal MAX_LONG_BDEC = new BigDecimal(Long.MAX_VALUE);
    public static final BigDecimal MIN_LONG_BDEC = new BigDecimal(Long.MIN_VALUE);

    private KafuNumber() {
    }

    public static boolean isBetweenExclusive(BigDecimal value, BigDecimal begin, BigDecimal end) {
        if (begin.compareTo(end) > 0) {
            throw new IllegalArgumentException(begin + " (begin) must smaller than (end) " + end);
        }
        return value.compareTo(begin) > 0 && value.compareTo(end) < 0;
    }

    public static boolean isBetweenInclusive(BigDecimal value, BigDecimal start, BigDecimal end) {
        if (start.compareTo(end) > 0) {
            throw new IllegalArgumentException(start + " (start) must smaller than (end) " + end);
        }
        return value.compareTo(start) >= 0 && value.compareTo(end) <= 0;
    }

    public static boolean isLongRange(BigDecimal value) {
        Objects.requireNonNull(value, "BigDecimal value REQUIRED");
        return KafuNumber.isBetweenInclusive(value, MIN_LONG_BDEC, MAX_LONG_BDEC);
    }

    public static void requireLongRange(BigDecimal value) {
        if (!KafuNumber.isLongRange(value)) {
            throw new RequirementException(value + " is not within long range");
        }
    }

    public static boolean randomBoolean() {
        return rand.nextBoolean();
    }

    public static int randomInt() {
        return rand.nextInt();
    }

    public static long randomLong() {
        return rand.nextLong();
    }

    public static int randomInt(int bound) {
        return rand.nextInt(bound);
    }

    public static int randomInt(int startInclusive, int endExclusive) {
        if (startInclusive >= endExclusive) {
            throw new IllegalArgumentException("start must be smaller than end");
        }
        long bound = (long)endExclusive - (long)startInclusive;
        if (bound == 1L) {
            return startInclusive;
        }
        long next = KafuNumber.randomLong(bound) + (long)startInclusive;
        if (next >= Integer.MAX_VALUE || next < Integer.MIN_VALUE) {
            throw new AssertionError((Object)("out of integer range: " + next));
        }
        return (int)next;
    }

    public static long randomLong(long bound) {
        if (bound < 1L) {
            throw new IllegalArgumentException("bound must be >= 1 but is " + bound);
        }
        if (bound < Integer.MAX_VALUE) {
            return rand.nextInt((int)bound);
        }
        if (rand.nextInt(4) == 0) {
            return rand.nextInt(Integer.MAX_VALUE);
        }
        long next = rand.nextLong();
        if (next < 0L) {
            next *= -1L;
        }
        while (next >= bound) {
            next /= 2L;
        }
        return next;
    }

    public static byte[] randomBytes(byte[] bytes) {
        rand.nextBytes(bytes);
        return bytes;
    }

    public static byte[] randomBytes(int size) {
        byte[] bytes = new byte[size];
        rand.nextBytes(bytes);
        return bytes;
    }

    public static boolean isZero(Number number) {
        Objects.requireNonNull(number, "REQUIRE number");
        if (number instanceof Integer || number instanceof Long || number instanceof Short || number instanceof Byte || number instanceof DataSize) {
            return number.longValue() == 0L;
        }
        if (number instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)number;
            return bd.compareTo(BigDecimal.ZERO) == 0;
        }
        String asString = number.toString();
        if (asString.startsWith("-")) {
            asString = asString.substring(1);
        }
        return asString.equals("0") || asString.equals("0.0");
    }

    public static boolean isNegative(Number number) {
        Objects.requireNonNull(number, "REQUIRE number");
        if (KafuNumber.isZero(number)) {
            return false;
        }
        return number.toString().stripLeading().startsWith("-");
    }
}

