/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.units;

import java.time.Duration;
import java.time.temporal.Temporal;
import java.util.Locale;
import java.util.Objects;
import net.kafujo.base.UncheckedException;
import net.kafujo.config.KafuVm;
import org.apache.commons.lang3.time.DurationFormatUtils;

public final class KafuDuration {
    public static final Duration MAX_VALUE = Duration.ofSeconds(Long.MAX_VALUE, 999999999L);
    public static final Duration MIN_VALUE = Duration.ofSeconds(Long.MIN_VALUE, 0L);
    public static final Duration ONE_NANO = Duration.ofNanos(1L);
    public static final Duration ONE_MILLI = Duration.ofMillis(1L);
    public static final Duration ONE_SECOND = Duration.ofSeconds(1L);
    public static final Duration ONE_MINUTE = Duration.ofMinutes(1L);
    public static final Duration ONE_HOUR = Duration.ofHours(1L);
    public static final Duration ONE_DAY = Duration.ofDays(1L);
    public static final Duration ONE_YEAR = Duration.ofDays(365L);
    public static final Duration ONE_DECADE = ONE_YEAR.multipliedBy(10L);
    public static final Duration ONE_CENTURY = ONE_YEAR.multipliedBy(100L);

    private KafuDuration() {
    }

    public static String adaptUnits(Duration duration) {
        Objects.requireNonNull(duration, "REQUIRE duration to be displayed");
        if (duration.isZero()) {
            return "0ns";
        }
        if (duration.equals(MAX_VALUE)) {
            return "MAX, more than 292 Billion years";
        }
        if (duration.equals(MIN_VALUE) || duration.abs().equals(MAX_VALUE)) {
            return "MIN, less than 292 Billion years";
        }
        if (duration.isNegative()) {
            return "-" + KafuDuration.adaptUnits(duration.abs());
        }
        try {
            if (duration.toNanos() < 1000000L) {
                return duration.toNanos() + "ns";
            }
            if (duration.toMillis() < 10000L) {
                return duration.toMillis() + "ms";
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        if (duration.toSeconds() < 60L) {
            return String.format("%d.%02ds", duration.toSecondsPart(), duration.toMillisPart() / 10);
        }
        if (duration.toMinutes() < 60L) {
            return String.format("%d:%02dmin", duration.toMinutesPart(), duration.toSecondsPart());
        }
        if (duration.toHours() < 24L) {
            return String.format("%d:%02d:%02dh", duration.toHoursPart(), duration.toMinutesPart(), duration.toSecondsPart());
        }
        long daysPart = duration.toDaysPart();
        assert (daysPart > 0L);
        if (daysPart < 365L) {
            if (daysPart == 1L) {
                return String.format("%d day %d:%02dh", daysPart, duration.toHoursPart(), duration.toMinutesPart());
            }
            return String.format("%d days %d:%02dh", daysPart, duration.toHoursPart(), duration.toMinutesPart());
        }
        long yearsPart = daysPart / 365L;
        long daysPartLeft = daysPart % 365L;
        if (yearsPart == 1L) {
            return String.format("%d year, %d days %dh", yearsPart, daysPartLeft, duration.toHoursPart());
        }
        return String.format("%d years, %d days %dh", yearsPart, daysPartLeft, duration.toHoursPart());
    }

    public static String adaptUnitsFbk(Duration duration, String fbk) {
        if (duration == null) {
            return fbk;
        }
        return KafuDuration.adaptUnits(duration);
    }

    public static String adaptUnits(Temporal startInclusive, Temporal endExclusive) {
        return KafuDuration.adaptUnits(Duration.between(startInclusive, endExclusive));
    }

    public static String adaptUnitsOfMillis(long millis) {
        if (millis == 0L) {
            return "0ms";
        }
        if (millis < 0L) {
            if (millis == Long.MIN_VALUE) {
                return "-" + KafuDuration.adaptUnitsOfMillis(Long.MAX_VALUE);
            }
            return "-" + KafuDuration.adaptUnitsOfMillis(-1L * millis);
        }
        if (millis < 10000L) {
            return millis + "ms";
        }
        return KafuDuration.adaptUnits(Duration.ofMillis(millis));
    }

    private static String usualDE(Duration duration) {
        Objects.requireNonNull(duration, "REQUIRE duration to display");
        if (duration.isZero()) {
            return "0:00:00";
        }
        if (duration.isNegative()) {
            return "-" + KafuDuration.usualDE(duration.abs());
        }
        long days = duration.toDays();
        if (days == 0L) {
            return String.format("%d:%02d:%02d", duration.toHoursPart(), duration.toMinutesPart(), duration.toSecondsPart());
        }
        if (days == 1L) {
            return String.format("1 Tag %d:%02d:%02d", duration.toHoursPart(), duration.toMinutesPart(), duration.toSecondsPart());
        }
        return String.format("%d Tage %d:%02d:%02d", days, duration.toHoursPart(), duration.toMinutesPart(), duration.toSecondsPart());
    }

    private static String usualEN(Duration duration) {
        Objects.requireNonNull(duration, "REQUIRE duration to display");
        if (duration.isZero()) {
            return "0:00:00";
        }
        if (duration.isNegative()) {
            return "-" + KafuDuration.usualEN(duration.abs());
        }
        if (duration.toDays() < 1L) {
            return DurationFormatUtils.formatDuration(duration.toMillis(), "H:mm:ss");
        }
        if (duration.abs().toDays() == 1L) {
            return DurationFormatUtils.formatDuration(duration.toMillis(), "d 'day' H:mm:ss");
        }
        return DurationFormatUtils.formatDuration(duration.toMillis(), "d 'days' H:mm:ss");
    }

    public static String usual(Duration duration) {
        return KafuDuration.usual(Locale.getDefault(), duration);
    }

    public static String usual(Locale locale, Duration duration) {
        Objects.requireNonNull(locale, "REQUIRE locale");
        switch (KafuVm.getLanguageFbk(locale, "en").toLowerCase()) {
            case "de": {
                return KafuDuration.usualDE(duration);
            }
        }
        return KafuDuration.usualEN(duration);
    }

    public static String usual(Locale locale, Duration duration, String def) {
        if (duration == null) {
            return def;
        }
        return KafuDuration.usual(locale, duration);
    }

    public static String usual(Duration duration, String def) {
        if (duration == null) {
            return def;
        }
        return KafuDuration.usual(duration);
    }

    public static long toMillisSafely(Duration duration) {
        long millis;
        Objects.requireNonNull(duration, "REQUIRE duration");
        try {
            millis = duration.toMillis();
        }
        catch (ArithmeticException threw) {
            millis = duration.isNegative() ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
        return millis;
    }

    public static long sleep(Duration duration) {
        long nanosStart = System.nanoTime();
        try {
            long millis = KafuDuration.toMillisSafely(duration);
            if (millis == 0L) {
                Thread.sleep(0L, duration.toNanosPart());
            }
            Thread.sleep(millis);
        }
        catch (InterruptedException interrupted) {
            throw new UncheckedException(interrupted);
        }
        return System.nanoTime() - nanosStart;
    }

    public static String adaptUnitsOfNanos(long nanos) {
        if (nanos == 0L) {
            return "0ns";
        }
        if (nanos < 0L) {
            if (nanos == Long.MIN_VALUE) {
                return "-" + KafuDuration.adaptUnitsOfNanos(Long.MAX_VALUE);
            }
            return "-" + KafuDuration.adaptUnitsOfNanos(-1L * nanos);
        }
        if (nanos < 1000000L) {
            return nanos + "ns";
        }
        if (nanos < 10000000000L) {
            return nanos / 1000000L + "ms";
        }
        return KafuDuration.adaptUnits(Duration.ofNanos(nanos));
    }
}

