/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.units;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KafuDateTime {
    public static final DateTimeFormatter COMPACT = DateTimeFormatter.ofPattern("dd.MM HH:mm");
    public static final DateTimeFormatter FULL_HUMAN = DateTimeFormatter.ofPattern("dd.MM.yyyy, HH:mm:ss");
    public static final DateTimeFormatter FULL = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter FULL_MILLIS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    public static final DateTimeFormatter FILENAME = DateTimeFormatter.ofPattern("yyyy-MM-dd-HHmmss");
    private static final Logger lgr = LoggerFactory.getLogger(KafuDateTime.class);

    public static String compact(LocalDateTime ldt, String def) {
        return ldt == null ? def : ldt.format(COMPACT);
    }

    public static String compact(LocalDateTime ldt) {
        Objects.requireNonNull(ldt, "REQUIRE LocalDateTime to format to String");
        return ldt.format(COMPACT);
    }

    public static String fullHuman(LocalDateTime ldt, String def) {
        return ldt == null ? def : ldt.format(FULL_HUMAN);
    }

    public static String full() {
        return KafuDateTime.full(LocalDateTime.now());
    }

    public static String full(Temporal timestamp) {
        Objects.requireNonNull(timestamp, "REQUIRE timestamp to format");
        return FULL.format(timestamp);
    }

    public static String full(Temporal timestamp, String def) {
        if (timestamp == null) {
            lgr.debug("fall back to default '{}', cause timestamp was null", (Object)def);
            return def;
        }
        try {
            return KafuDateTime.full(timestamp);
        }
        catch (RuntimeException anyRt) {
            if (lgr.isDebugEnabled()) {
                lgr.debug("COULD NOT FORMAT '" + timestamp + "' TO TIMESTAMP", anyRt);
            } else {
                lgr.info("COULD NOT FORMAT '{}' TO TIMESTAMP CAUSE {}", (Object)timestamp, (Object)anyRt.toString());
            }
            return def;
        }
    }

    public static String full(Instant instant) {
        Objects.requireNonNull(instant, "REQUIRE instant to be formatted");
        return KafuDateTime.full(LocalDateTime.ofInstant(instant, ZoneId.systemDefault()));
    }

    public static ZoneOffset getUtcOffset() {
        return KafuDateTime.getUtcOffset(ZoneId.systemDefault());
    }

    public static ZoneOffset getUtcOffset(ZoneId zone) {
        return zone.getRules().getOffset(Instant.now());
    }

    public static ZoneOffset getUtcOffset(ZonedDateTime time) {
        return time.getZone().getRules().getOffset(Instant.now());
    }

    public static boolean sameUtcOffset(ZoneId zone1, ZoneId zone2) {
        return KafuDateTime.getUtcOffset(zone1).equals(KafuDateTime.getUtcOffset(zone2));
    }

    public static boolean sameUtcOffset(ZonedDateTime time, ZonedDateTime time2) {
        return KafuDateTime.getUtcOffset(time).equals(KafuDateTime.getUtcOffset(time2));
    }
}

