/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.units;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import net.kafujo.units.DataSize;
import net.kafujo.units.KafuNumber;

public enum DataSizeUnit implements Comparable<DataSizeUnit>
{
    Byte("Byte", "DataSize", DataSize.of(1L), true),
    KB("Kilobyte", "Kilobytes", DataSizeUnit.Byte.size.times(1000L), false),
    KiB("Kibibyte", "Kibibytes", DataSizeUnit.Byte.size.times(1024L), true),
    MB("Megabyte", "Megabytes", DataSizeUnit.KB.size.times(1000L), false),
    MiB("Mebibyte", "Mebibytes", DataSizeUnit.KiB.size.times(1024L), true),
    GB("Gigabyte", "Gigabytes", DataSizeUnit.MB.size.times(1000L), false),
    GiB("Gibibyte", "Gibibytes", DataSizeUnit.MiB.size.times(1024L), true),
    TB("Terabyte", "Terabytes", DataSizeUnit.GB.size.times(1000L), false),
    TiB("Tebibyte", "Tebibytes", DataSizeUnit.GiB.size.times(1024L), true),
    PB("Petabyte", "Petabytes", DataSizeUnit.TB.size.times(1000L), false),
    PiB("Pebibyte", "Pebibytes", DataSizeUnit.TiB.size.times(1024L), true),
    EB("Exabyte", "Exabytes", DataSizeUnit.PB.size.times(1000L), false),
    EiB("Exbibyte", "Exbibytes", DataSizeUnit.PiB.size.times(1024L), true);

    public final DataSize size;
    public final String name;
    public final String namePlural;
    private final boolean iec;

    private DataSizeUnit(String name, String namePlural, DataSize dataSize, boolean iec) {
        this.name = name;
        this.namePlural = namePlural;
        this.size = dataSize;
        this.iec = iec;
    }

    DataSize convert(BigDecimal value) {
        Objects.requireNonNull(value, "BigDecimal value REQUIRED");
        BigDecimal bytes = value.multiply(this.size.toBigDecimal());
        if (bytes.compareTo(KafuNumber.MAX_LONG_BDEC) > 0) {
            throw new IllegalArgumentException("value too big to be converted to DataSize: " + bytes + " Bytes");
        }
        if (bytes.compareTo(KafuNumber.MIN_LONG_BDEC.add(BigDecimal.ONE)) < 0) {
            throw new IllegalArgumentException("byte value too small to be converted to DataSize: " + bytes + " Bytes");
        }
        return DataSize.of(bytes.longValue());
    }

    public String format(long bytes) {
        return this.format(bytes, 2);
    }

    public String format(long bytes, int scale) {
        return this.format(DataSize.of(bytes), scale);
    }

    public String format(DataSize val) {
        return this.format(val, 2);
    }

    public String format(DataSize val, int scale) {
        if (this == Byte) {
            scale = 0;
        }
        BigDecimal valOut = val.toBigDecimal().divide(this.size.toBigDecimal(), scale, RoundingMode.HALF_DOWN);
        return String.format("%s %s", valOut.toPlainString(), this);
    }

    public String formatLong(DataSize dataSize, int scale) {
        BigDecimal valOut;
        if (this == Byte) {
            scale = 0;
        }
        if ((valOut = dataSize.toBigDecimal().divide(this.size.toBigDecimal(), scale, RoundingMode.HALF_DOWN)).compareTo(BigDecimal.ONE) == 0) {
            return String.format("%s %s", valOut.toPlainString(), this.name);
        }
        return String.format("%s %s", valOut.toPlainString(), this.namePlural);
    }

    public String formatLong(DataSize ds) {
        return this.formatLong(ds, 2);
    }

    public String formatLong(long bytes) {
        return this.formatLong(bytes, 2);
    }

    public String formatLong(long bytes, int scale) {
        return this.formatLong(DataSize.of(bytes), scale);
    }

    public boolean isIec() {
        return this.iec;
    }

    public boolean isIs() {
        if (this == Byte) {
            return true;
        }
        return !this.iec;
    }
}

