/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.units;

import java.io.Serializable;
import java.util.Objects;
import net.kafujo.units.DataSize;

public class DataSizeCounter
implements Serializable {
    private long byteCount = 0L;
    private long itemCount = 0L;

    public DataSizeCounter add(DataSize file) {
        this.byteCount += file.longValue();
        ++this.itemCount;
        return this;
    }

    public DataSizeCounter add(DataSizeCounter other) {
        this.byteCount += other.byteCount;
        this.itemCount += other.itemCount;
        return this;
    }

    public DataSize getDataSize() {
        return DataSize.of(this.byteCount);
    }

    public long getItemCount() {
        return this.itemCount;
    }

    public String toString() {
        return "counted " + this.itemCount + " items of total " + this.getDataSize();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSizeCounter that = (DataSizeCounter)o;
        return this.byteCount == that.byteCount && this.itemCount == that.itemCount;
    }

    public int hashCode() {
        return Objects.hash(this.byteCount, this.itemCount);
    }
}

