/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.units;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kafujo.units.DataSizeUnit;

public class DataSize
extends Number
implements Serializable,
Comparable<DataSize> {
    private static final Pattern parser = Pattern.compile("\\p{Alpha}");
    public static final DataSize MAX_VALUE = DataSize.of(Long.MAX_VALUE);
    public static final DataSize MIN_VALUE = DataSize.of(-9223372036854775807L);
    public static final DataSize ZERO = DataSize.of(0L);
    public static final DataSize ONE_BYTE = DataSize.of(1L);
    public static final DataSize ONE_KB = DataSize.of(1000L);
    public static final DataSize ONE_KiB = DataSize.of(1024L);
    public static final DataSize ONE_MB = DataSize.of(1L, DataSizeUnit.MB);
    public static final DataSize ONE_MiB = DataSize.of(1L, DataSizeUnit.MiB);
    public static final DataSize ONE_GiB = DataSize.of("1GiB");
    public static final DataSize ONE_TiB = DataSize.of("1TiB");
    public static final DataSize ONE_EiB = DataSize.of("1EiB");
    static final int DEFAULT_SCALE = 2;
    private final long bytes;

    private DataSize(long bytes) {
        this.bytes = bytes;
    }

    public static DataSize of(long bytes) {
        if (bytes == Long.MIN_VALUE) {
            throw new IllegalArgumentException("Long.MIN_VALUE is too small to be converted to DataSize, minimal value allowed is Long.MIN_VALUE + 1");
        }
        return new DataSize(bytes);
    }

    public static DataSize of(long value, DataSizeUnit unit) {
        return unit.size.times(value);
    }

    public static DataSize of(double value, DataSizeUnit unit) {
        return unit.convert(BigDecimal.valueOf(value));
    }

    public static DataSize of(BigDecimal value, DataSizeUnit unit) {
        return unit.convert(value);
    }

    public static DataSize of(String value, DataSizeUnit unit) {
        return unit.convert(new BigDecimal(value));
    }

    public static String toString(long bytes) {
        return new DataSize(bytes).toString();
    }

    public static String toString(long bytes, int scale) {
        return new DataSize(bytes).toString(scale);
    }

    public static String toStringLong(long bytes) {
        return new DataSize(bytes).toStringLong();
    }

    public static String toStringLong(long bytes, int scale) {
        return new DataSize(bytes).toStringLong(scale);
    }

    public static DataSize of(String in) {
        Matcher m = parser.matcher(in);
        if (!m.find() || m.start() == 0) {
            throw new IllegalArgumentException("Format needed: \"!{number} {DataSizeUnit}\"");
        }
        BigDecimal number = new BigDecimal(in.substring(0, m.start()).strip());
        DataSizeUnit unit = DataSizeUnit.valueOf(in.substring(m.start()).strip());
        return unit.convert(number);
    }

    @Override
    public long longValue() {
        return this.bytes;
    }

    @Override
    public int intValue() {
        if (this.bytes > Integer.MAX_VALUE || this.bytes < Integer.MIN_VALUE) {
            throw new IllegalStateException("DataSize does not fit in int: " + this);
        }
        return (int)this.bytes;
    }

    @Override
    public float floatValue() {
        return this.bytes;
    }

    @Override
    public double doubleValue() {
        return 0.0;
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.bytes);
    }

    public boolean isZero() {
        return this.bytes == 0L;
    }

    public boolean isSmallerThan(DataSize other) {
        return this.bytes < other.bytes;
    }

    public boolean isBiggerThan(DataSize other) {
        return this.bytes > other.bytes;
    }

    public boolean isNegative() {
        return this.bytes < 0L;
    }

    public DataSize abs() {
        if (this.isNegative()) {
            return new DataSize(this.bytes * -1L);
        }
        return this;
    }

    public DataSize plus(DataSize amountToAdd) {
        Objects.requireNonNull(amountToAdd, "cannot add null ByteSize");
        return this.plus(amountToAdd.bytes);
    }

    public DataSize plus(long bytesToAdd) {
        if (bytesToAdd == 0L) {
            return this;
        }
        return DataSize.of(Math.addExact(this.bytes, bytesToAdd));
    }

    public DataSize minus(DataSize amountToSubtract) {
        Objects.requireNonNull(amountToSubtract, "cannot subtract null ByteSize");
        return this.minus(amountToSubtract.bytes);
    }

    public DataSize minus(long bytesToSubtract) {
        if (bytesToSubtract == 0L) {
            return this;
        }
        return DataSize.of(Math.subtractExact(this.bytes, bytesToSubtract));
    }

    public DataSize times(long factor) {
        if (factor == 0L) {
            return ZERO;
        }
        if (factor == 1L) {
            return this;
        }
        return DataSize.of(Math.multiplyExact(this.bytes, factor));
    }

    public String toString() {
        return this.toString(2);
    }

    public String toString(int scale) {
        if (this.isNegative()) {
            return "-" + this.abs().toString(scale);
        }
        if (this.isSmallerThan(DataSizeUnit.KiB.size)) {
            return DataSizeUnit.Byte.format(this, scale);
        }
        if (this.isSmallerThan(DataSizeUnit.MiB.size)) {
            return DataSizeUnit.KiB.format(this, scale);
        }
        if (this.isSmallerThan(DataSizeUnit.GiB.size)) {
            return DataSizeUnit.MiB.format(this, scale);
        }
        if (this.isSmallerThan(DataSizeUnit.TiB.size)) {
            return DataSizeUnit.GiB.format(this, scale);
        }
        if (this.isSmallerThan(DataSizeUnit.PiB.size)) {
            return DataSizeUnit.TiB.format(this, scale);
        }
        if (this.isSmallerThan(DataSizeUnit.EiB.size)) {
            return DataSizeUnit.PiB.format(this, scale);
        }
        return DataSizeUnit.EiB.format(this, scale);
    }

    public String toStringLong() {
        return this.toStringLong(2);
    }

    public String toStringLong(int scale) {
        if (this.isNegative()) {
            return "-" + this.abs().toStringLong(scale);
        }
        if (this.isSmallerThan(DataSizeUnit.KiB.size)) {
            return DataSizeUnit.Byte.formatLong(this, scale);
        }
        if (this.isSmallerThan(DataSizeUnit.MiB.size)) {
            return DataSizeUnit.KiB.formatLong(this, scale);
        }
        if (this.isSmallerThan(DataSizeUnit.GiB.size)) {
            return DataSizeUnit.MiB.formatLong(this, scale);
        }
        if (this.isSmallerThan(DataSizeUnit.TiB.size)) {
            return DataSizeUnit.GiB.formatLong(this, scale);
        }
        if (this.isSmallerThan(DataSizeUnit.PiB.size)) {
            return DataSizeUnit.TiB.formatLong(this, scale);
        }
        if (this.isSmallerThan(DataSizeUnit.EiB.size)) {
            return DataSizeUnit.PiB.formatLong(this, scale);
        }
        return DataSizeUnit.EiB.formatLong(this, scale);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSize dataSize = (DataSize)o;
        return this.bytes == dataSize.bytes;
    }

    public int hashCode() {
        return Objects.hash(this.bytes);
    }

    @Override
    public int compareTo(DataSize o) {
        return Long.compare(this.bytes, o.bytes);
    }
}

