/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.text;

import java.util.Objects;

public final class KafuText {
    public static final String UNIVERSAL_NA = "N/A";
    public static final String UNIVERSAL_MAX = "MAX";
    public static final String UNIVERSAL_MIN = "MIN";
    public static final String NULL = null;

    private KafuText() {
    }

    public static boolean equalsUniversalNotAvailable(String test) {
        return UNIVERSAL_NA.equalsIgnoreCase(test);
    }

    public static boolean equalsUniversalMin(String valueString) {
        return UNIVERSAL_MIN.equalsIgnoreCase(valueString);
    }

    public static boolean equalsUniversalMax(String valueString) {
        return UNIVERSAL_MAX.equalsIgnoreCase(valueString);
    }

    public static String getFirstLine(CharSequence manyLines) {
        Objects.requireNonNull(manyLines, "REQUIRE manaylines");
        return manyLines.toString().split("\\r?\\n", 2)[0];
    }

    public static String replaceUmlauts(String input) {
        String tail;
        Objects.requireNonNull(input, "REQUIRE input to be cleaned from umlauts");
        if (input.length() == 0) {
            return input;
        }
        String output = input.replace("\u00fc", "ue").replace("\u00f6", "oe").replace("\u00e4", "ae").replace("\u00df", "ss");
        if (output.length() > 1 && (output.startsWith("\u00c4") || output.startsWith("\u00d6") || output.startsWith("\u00dc")) && (tail = output.substring(1)).equals(tail.toLowerCase())) {
            output = output.replace("\u00dc", "Ue").replace("\u00d6", "Oe").replace("\u00c4", "Ae");
        }
        output = output.replace("\u00dc", "UE").replace("\u00d6", "OE").replace("\u00c4", "AE");
        return output;
    }
}

