/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.text;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class KafuFormat {
    public static String xml(String input, int indent) {
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(input));
            StringWriter stringWriter = new StringWriter();
            StreamResult xmlOutput = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", indent);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String xml(String input) {
        return KafuFormat.xml(input, 2);
    }

    public static String xmlSafely(String input) {
        try {
            return KafuFormat.xml(input, 2);
        }
        catch (Exception ignore) {
            return input;
        }
    }

    public static String stripAll(String in) {
        return in.strip().replaceAll("\\s+", " ");
    }
}

