/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.reflect;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Objects;
import net.kafujo.base.KafujoException;
import net.kafujo.io.KafuFile;

public final class KafuReflect {
    public static Object instantiateByName(String className) {
        Objects.requireNonNull(className);
        try {
            Class<?> clazz = Class.forName(className);
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new KafujoException("KafuRefelect.instantiateByName() could not create object of class " + className, e);
        }
    }

    public static <T> T instantiateByName(String className, Class<T> type) {
        Objects.requireNonNull(type);
        return type.cast(KafuReflect.instantiateByName(className));
    }

    public static URLClassLoader getClassLoaderForJar(Path jar) {
        KafuFile.requireReadable(jar);
        try {
            URL[] urls = new URL[]{jar.toUri().toURL()};
            return new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        }
        catch (MalformedURLException e) {
            throw new KafujoException("FAILED TO LOAD " + jar, e);
        }
    }
}

