/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.network;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import net.kafujo.base.RequirementException;
import net.kafujo.base.UncheckedException;
import net.kafujo.network.Host;
import net.kafujo.network.Hostname;
import net.kafujo.text.KafuText;

public class Port
extends Number
implements Serializable {
    private static final long serialVersionUID = -8434081743063482592L;
    public static final int MIN_PORT_NO = 0;
    public static final int MAX_SYSTEM_PORT_NO = 1023;
    public static final int MAX_USER_PORT_NO = 49151;
    public static final int MAX_PORT_NO = 65535;
    public static final Port NOT_PRESENT = new Port(-1);
    public static final Port FTP = new Port(20);
    public static final Port FTPCTL = new Port(21);
    public static final Port SSH = new Port(22);
    public static final Port TELNET = new Port(23);
    public static final Port DNS = new Port(53);
    public static final Port NNTP = new Port(119);
    public static final Port NTP = new Port(123);
    public static final Port IRC = new Port(194);
    public static final Port HTTP = new Port(80);
    public static final Port HTTPS = new Port(443);
    public static final Port SMTP = new Port(25);
    public static final Port POP2 = new Port(109);
    public static final Port POP3 = new Port(110);
    public static final Port IMAP = new Port(143);
    public static final Port IMAPS = new Port(993);
    public static final Port MYSQL = new Port(3306);
    public static final Port POSTGRESQL = new Port(5432);
    public static final Port SQLSERVER = new Port(1433);
    private final int portNo;

    public Port(int portNo) {
        if (!Port.isValid(portNo) && portNo != -1) {
            throw new IllegalArgumentException("INVALID PORT: " + portNo + "; must be -1, 65535 or in between");
        }
        this.portNo = portNo;
    }

    public static boolean isValid(int portNo) {
        return portNo >= 0 && portNo <= 65535;
    }

    public static Port of(String portStr) {
        Objects.requireNonNull(portStr, "REQUIRE port String representation to create Port object");
        if (KafuText.equalsUniversalNotAvailable(portStr) || portStr.equals("-1")) {
            return NOT_PRESENT;
        }
        return new Port(Integer.parseInt(portStr));
    }

    public static Port of(Host host) {
        Objects.requireNonNull(host, "REQUIRE host to fetch port from");
        return host.getPort();
    }

    public static Port ofUrl(URL url) {
        Objects.requireNonNull(url, "REQUIRE url to extract port from");
        return new Port(url.getPort());
    }

    public static Port ofUrl(String url) {
        Objects.requireNonNull(url, "REQUIRE url to extract port from");
        try {
            return Port.ofUrl(new URL(url));
        }
        catch (MalformedURLException fail) {
            throw new IllegalArgumentException(fail);
        }
    }

    public boolean isEmpty() {
        return this.portNo == -1;
    }

    public boolean isPresent() {
        return this.portNo != -1;
    }

    public boolean isSystemPort() {
        return this.portNo >= 0 && this.portNo <= 1023;
    }

    public boolean isUserPort() {
        return this.portNo > 1023 && this.portNo <= 49151;
    }

    public boolean isDynamicPort() {
        return this.portNo > 49151 && this.portNo <= 65535;
    }

    @Override
    public int intValue() {
        return this.portNo;
    }

    @Override
    public long longValue() {
        return this.portNo;
    }

    @Override
    public float floatValue() {
        return this.portNo;
    }

    @Override
    public double doubleValue() {
        return this.portNo;
    }

    public String toString() {
        return this.equals(NOT_PRESENT) ? "N/A" : Integer.toString(this.portNo);
    }

    public String toHostAttachment() {
        if (this.isEmpty()) {
            return "";
        }
        return ":" + this.portNo;
    }

    public String attachToUrl(String url) {
        Objects.requireNonNull(url, "REQUIRE url to attach port " + this);
        Port current = Port.ofUrl(url);
        if (current.equals(this)) {
            return url;
        }
        if (current.isEmpty()) {
            return url + ":" + this.portNo;
        }
        throw new IllegalArgumentException("Don't want to change existing port of " + url + " to " + this);
    }

    public URL attachToUrl(URL url) {
        Objects.requireNonNull(url, "REQUIRE url to attach port " + this);
        Port current = new Port(url.getPort());
        if (current.equals(this)) {
            return url;
        }
        if (current.isEmpty()) {
            try {
                return new URL(url.getProtocol(), url.getHost(), this.portNo, url.getFile());
            }
            catch (MalformedURLException malformed) {
                throw new UncheckedException("Cannot happen", malformed);
            }
        }
        throw new IllegalArgumentException("Don't want to change existing port of " + url + " to " + this);
    }

    public Host attachTo(Hostname hostname) {
        Objects.requireNonNull(hostname, "REQUIRE hostname to attach port '" + this + "' to");
        return new Host(hostname.toString(), this);
    }

    public Host attachTo(Host host) {
        Objects.requireNonNull(host, "REQUIRE host to attach port '" + this + "' to");
        if (this.equals(host.getPort())) {
            return host;
        }
        if (host.getPort().isEmpty()) {
            return new Host(host.getIdentifier(), this);
        }
        throw new IllegalArgumentException("Don't want to change existing port of " + host + " to " + this);
    }

    public String attachTo(String arbitrary) {
        return arbitrary + this.toHostAttachment();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Port port1 = (Port)o;
        return this.portNo == port1.portNo;
    }

    public int hashCode() {
        return Objects.hash(this.portNo);
    }

    public static Port requirePresent(Port port) {
        if (port == null || port.isEmpty()) {
            throw new RequirementException("REQUIRE port!");
        }
        return port;
    }
}

