/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.network;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import net.kafujo.base.RequirementException;
import net.kafujo.base.UncheckedException;
import net.kafujo.network.Port;
import org.apache.commons.lang3.StringUtils;

public final class KafuNet {
    private static final Pattern PATTERN_HOSTNAME = Pattern.compile("^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])$");
    static final Pattern PATTERN_IP4 = Pattern.compile("^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");

    private KafuNet() {
    }

    public static boolean isValidHostname(String hostname) {
        if (hostname == null || hostname.isBlank() || !hostname.strip().equals(hostname)) {
            return false;
        }
        return PATTERN_HOSTNAME.matcher(hostname).matches();
    }

    public static String requireValidHostname(String hostname) {
        if (!KafuNet.isValidHostname(hostname)) {
            throw new RequirementException("'" + hostname + "' is not a valid hostname");
        }
        return hostname;
    }

    public static boolean isValidHost(String host) {
        if (host == null || host.isBlank() || !host.strip().equals(host) || host.contains("@")) {
            return false;
        }
        if (host.endsWith(":-1")) {
            return false;
        }
        try {
            URL url = new URL("http://" + host);
            if (StringUtils.isNotEmpty(url.getPath())) {
                return false;
            }
            int port = url.getPort();
            if (!Port.isValid(port) && port != -1) {
                return false;
            }
            return KafuNet.isValidHostname(url.getHost());
        }
        catch (MalformedURLException malformed) {
            return false;
        }
    }

    public static String requireValidHost(String host) {
        if (!KafuNet.isValidHost(host)) {
            throw new RequirementException("'" + host + "' is not a valid host");
        }
        return host;
    }

    public static boolean isValidIp4Address(String ip) {
        if (ip == null || ip.isBlank()) {
            return false;
        }
        return PATTERN_IP4.matcher(ip).matches();
    }

    public static String requireValidIp4Address(String ip) {
        if (!KafuNet.isValidIp4Address(ip)) {
            throw new IllegalArgumentException("Not a valid IP4 address: " + ip);
        }
        return ip;
    }

    public static String getHostInfo() {
        try {
            return InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e) {
            throw new UncheckedException(e);
        }
    }

    public static String getHostInfoFbk(String fbk) {
        try {
            return InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException ignore) {
            return fbk;
        }
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new UncheckedException(e);
        }
    }

    public static String getHostNameFbk(String fbk) {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ignore) {
            return fbk;
        }
    }

    public static String getCanonicalHostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            throw new UncheckedException(e);
        }
    }

    public static String getCanonicalHostNameFbk(String fbk) {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ignore) {
            return fbk;
        }
    }

    public static boolean isValidIp4(String ip) {
        return false;
    }

    public static boolean isValidIp4WithOptionalPort(String ipWithOptionalPort) {
        return false;
    }
}

