/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.network;

import java.io.Serializable;
import java.net.URL;
import java.util.Objects;
import net.kafujo.network.Host;
import net.kafujo.network.KafuNet;
import net.kafujo.network.Port;

public class Ip4AddressOptionalPort
extends Host
implements Serializable {
    private static final long serialVersionUID = 3769197629954609351L;

    public static Ip4AddressOptionalPort ofUrl(URL url) {
        Objects.requireNonNull(url, "REQUIRE url to extract ip4 address and port from");
        return new Ip4AddressOptionalPort(url.getHost(), url.getPort());
    }

    public Ip4AddressOptionalPort(String host) {
        super(host);
        KafuNet.requireValidIp4Address(this.getIdentifier());
    }

    public Ip4AddressOptionalPort(String host, int portNo) {
        this(host, new Port(portNo));
    }

    public Ip4AddressOptionalPort(String host, Port port) {
        super(host, port);
        KafuNet.requireValidIp4Address(this.getIdentifier());
    }
}

