/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.network;

import java.net.URL;
import java.util.Objects;
import net.kafujo.network.HostIdentifierNoPort;
import net.kafujo.network.KafuNet;

public class Ip4Address
implements HostIdentifierNoPort {
    private static final long serialVersionUID = -1066731858227851076L;
    private final String ip;

    public static Ip4Address ofUrl(URL url) {
        Objects.requireNonNull(url, "REQUIRE url to extract ip4 address from");
        return new Ip4Address(url.getHost());
    }

    public Ip4Address(String ip4address) {
        Objects.requireNonNull(ip4address, "ip4 address String to create Ip4Address object");
        this.ip = KafuNet.requireValidIp4Address(ip4address.trim());
    }

    @Override
    public String getIdentifier() {
        return this.ip;
    }
}

