/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.network;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Objects;
import net.kafujo.base.UncheckedException;

public interface HostIdentifierNoPort
extends Serializable {
    public String getIdentifier();

    default public boolean isResolvable() {
        try {
            InetAddress.getByName(this.getIdentifier());
            return true;
        }
        catch (UnknownHostException trouble) {
            return false;
        }
    }

    default public URL toUrl(String protocol) {
        return this.toUrl(protocol, "");
    }

    default public URL toUrl(String protocol, String path) {
        Objects.requireNonNull(protocol, "REQUIRE protocol to create url for " + this.getIdentifier());
        try {
            return new URL(protocol, this.getIdentifier(), -1, path);
        }
        catch (MalformedURLException trouble) {
            throw new UncheckedException("could not create url for '" + this.getIdentifier() + "', protocol " + protocol + " and path " + path, trouble);
        }
    }

    default public InetAddress toInetAddress() {
        try {
            return InetAddress.getByName(this.getIdentifier());
        }
        catch (UnknownHostException trouble) {
            throw new UncheckedException("could not resolve " + this.getIdentifier(), trouble);
        }
    }
}

