/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.network;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import net.kafujo.base.UncheckedException;
import net.kafujo.network.HostIdentifier;
import net.kafujo.network.KafuNet;
import net.kafujo.network.Port;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Host
implements HostIdentifier {
    private static final long serialVersionUID = -6620466287330533952L;
    public static final Logger lgr = LoggerFactory.getLogger(Host.class);
    private final String identifier;
    private final Port port;

    public static Host ofUrl(URL url) {
        Objects.requireNonNull(url, "REQUIRE url to extract host from");
        return new Host(url.getHost(), Port.ofUrl(url));
    }

    public Host(String host) {
        this(host, false);
    }

    protected Host(String host, boolean ignorePort) {
        KafuNet.requireValidHost(host);
        try {
            URL url = new URL("http://" + host);
            this.identifier = url.getHost().strip();
            this.port = ignorePort ? Port.NOT_PRESENT : Port.ofUrl(url);
        }
        catch (MalformedURLException cannotHappen) {
            throw new UncheckedException(cannotHappen);
        }
    }

    public Host(String identifier, Port port) {
        Objects.requireNonNull(identifier, "REQUIRE name of host to construct Host object");
        Objects.requireNonNull(port, "REQUIRE port to construct Host object");
        this.identifier = KafuNet.requireValidHostname(identifier.strip());
        this.port = port;
    }

    @Override
    public Port getPort() {
        return this.port;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return this.port.attachTo(this.identifier);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Host)) {
            return false;
        }
        Host host = (Host)o;
        return this.identifier.equals(host.identifier) && this.port.equals(host.port);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.port);
    }
}

