/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.network;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.regex.Pattern;
import net.kafujo.base.UncheckedException;
import org.apache.commons.lang3.StringUtils;

public class EmailAddress
implements Serializable {
    private static final long serialVersionUID = -1917522446192564518L;
    private final String email;
    private static final Pattern pattern = Pattern.compile("^.+@.+\\..+$");

    public static EmailAddress of(URL url) {
        if ("mailto".equalsIgnoreCase(url.getProtocol())) {
            return new EmailAddress(url.getPath());
        }
        throw new IllegalArgumentException("URL '" + url + "' is not an email address");
    }

    public EmailAddress(String emailStr) {
        Objects.requireNonNull(emailStr, "REQUIRE email string to create EmailAddress object from");
        String stripped = emailStr.strip();
        if (!EmailAddress.isValid(stripped)) {
            throw new IllegalArgumentException(emailStr + " is not a valid email");
        }
        this.email = stripped;
    }

    public static boolean isValid(String email) {
        if (email == null || email.strip().length() < 3 || StringUtils.countMatches((CharSequence)email, '@') != 1 || email.startsWith("mailto:") || email.contains(" ") || email.contains("..") || email.contains("@-") || email.contains("-@") || email.contains("@.") || email.contains(".@") || email.startsWith("@") || email.endsWith("@") || email.startsWith(".") || email.endsWith(".") || email.endsWith(";")) {
            return false;
        }
        return pattern.matcher(email).matches();
    }

    public URL toUrl() {
        try {
            return new URL("mailto:" + this.email);
        }
        catch (MalformedURLException trouble) {
            throw new UncheckedException("Could not create url out of " + this.email, trouble);
        }
    }

    public String getEmailAsString() {
        return this.email;
    }

    public String toString() {
        return this.email;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailAddress that = (EmailAddress)o;
        return Objects.equals(this.email, that.email);
    }

    public int hashCode() {
        return Objects.hash(this.email);
    }
}

