/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kafujo.base.RequirementException;
import net.kafujo.io.KafuFile;
import net.kafujo.io.KafuInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceReader {
    private static final Logger lgr = LoggerFactory.getLogger(ResourceReader.class);
    private static final Map<ClassLoader, ResourceReader> readers = new HashMap<ClassLoader, ResourceReader>();
    private final ClassLoader loader;

    private ResourceReader(ClassLoader loader) {
        this.loader = Objects.requireNonNull(loader, "REQUIRE loader");
    }

    public static synchronized ResourceReader instance() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return readers.computeIfAbsent(loader, ResourceReader::new);
    }

    public static synchronized ResourceReader instance(Class clazz) {
        Objects.requireNonNull(clazz, "REQUIRE clazz");
        ClassLoader loader = clazz.getClassLoader();
        return readers.computeIfAbsent(loader, ResourceReader::new);
    }

    public static synchronized ResourceReader instance(ClassLoader loader) {
        return readers.computeIfAbsent(loader, ResourceReader::new);
    }

    public static Map<ClassLoader, ResourceReader> getReaders() {
        return Collections.unmodifiableMap(readers);
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public boolean isAvailable(String resourceName) {
        Objects.requireNonNull(resourceName, "REQUIRE resourceName");
        return this.loader.getResource(resourceName) != null;
    }

    public String requireAvailability(String resourceName) {
        if (!this.isAvailable(resourceName)) {
            throw new RequirementException("Resource '" + resourceName + "' not available");
        }
        return resourceName;
    }

    public String requireAvailability(String resourceName, String message) {
        if (!this.isAvailable(resourceName)) {
            throw new RequirementException("Resource '" + resourceName + "' not available: " + message);
        }
        return resourceName;
    }

    public Path asPath(String resourceName) {
        this.requireAvailability(resourceName);
        try {
            URL url = this.loader.getResource(resourceName);
            Path file = Paths.get(url.toURI());
            return file.toAbsolutePath();
        }
        catch (URISyntaxException e) {
            throw new RequirementException("Having trouble fetching resource: " + resourceName, e);
        }
    }

    public InputStream asStream(String resourceName) {
        this.requireAvailability(resourceName);
        return this.loader.getResourceAsStream(resourceName);
    }

    public String asString(String resourceName) {
        return KafuInput.asString(this.asStream(resourceName));
    }

    public List<String> asLines(String resourceName) {
        return KafuInput.asLines(this.asStream(resourceName));
    }

    public Path asTempFile(String resourceName) {
        this.requireAvailability(resourceName);
        String filenamePart = Paths.get(resourceName, new String[0]).getFileName().toString();
        Path path = null;
        try (InputStream resourceInputStream = this.asStream(resourceName);){
            path = Files.createTempFile("kafujo_", "_" + filenamePart, new FileAttribute[0]);
            Files.copy(resourceInputStream, path, StandardCopyOption.REPLACE_EXISTING);
            lgr.debug("copied resource {} to {}", (Object)resourceName, (Object)KafuFile.sizeAndPath(path));
        }
        catch (IOException io) {
            String msg = "IO PROBLEM WRITING RESOURCE '" + resourceName + "' TO TEMP FILE " + path;
            lgr.info(msg, io);
            throw new UncheckedIOException(msg, io);
        }
        return path;
    }

    public Path asFile(String resourceName, Path destination, CopyOption ... options) {
        this.requireAvailability(resourceName);
        if (Files.exists(destination, new LinkOption[0])) {
            KafuFile.requireNotDirectory(destination);
        }
        try (InputStream resourceInputStream = this.asStream(resourceName);){
            Files.copy(resourceInputStream, destination, options);
            lgr.debug("copied resource {} to {}", (Object)resourceName, (Object)KafuFile.sizeAndPath(destination));
        }
        catch (IOException io) {
            String msg = "IO PROBLEM WRITING RESOURCE '" + resourceName + "' TO " + destination.toAbsolutePath();
            lgr.info(msg, io);
            throw new UncheckedIOException(msg, io);
        }
        return destination;
    }

    public Path asFile(String resourceName, Path destination) {
        return this.asFile(resourceName, destination, StandardCopyOption.REPLACE_EXISTING);
    }
}

