/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.io;

import java.io.Closeable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.kafujo.io.KafuFile;
import net.kafujo.io.KafuResource;

public class ResourceFileEscapee
implements Closeable {
    private final Map<String, Integer> accessCounter = new HashMap<String, Integer>();
    private final Map<String, Path> mapper = new HashMap<String, Path>();
    private final String resourcePrefix;
    private int cleanUps = 0;

    public ResourceFileEscapee(String prefix) {
        Objects.requireNonNull(prefix, "REQUIRE prefix to mark resources");
        this.resourcePrefix = prefix;
    }

    @Override
    public void close() {
        for (String handle : this.mapper.keySet()) {
            KafuFile.deleteQuietly(this.mapper.get(handle));
            this.mapper.remove(handle);
        }
        ++this.cleanUps;
    }

    public String getResourcePrefix() {
        return this.resourcePrefix;
    }

    public Map<String, Path> getMapper() {
        return Collections.unmodifiableMap(this.mapper);
    }

    public Map<String, Integer> getAccessCounter() {
        return Collections.unmodifiableMap(this.accessCounter);
    }

    public int getAccessCount() {
        AtomicInteger count = new AtomicInteger(0);
        this.accessCounter.keySet().forEach(handle -> count.addAndGet(this.accessCounter.get(handle)));
        return count.intValue();
    }

    public int getAccessCount(Path handle) {
        Objects.requireNonNull(handle, "REQUIRE handle to fetch access count");
        return this.getAccessCount(handle.toString());
    }

    public int getAccessCount(String handle) {
        Objects.requireNonNull(handle, "REQUIRE handle to fetch access count");
        Integer ret = this.accessCounter.get(handle);
        if (ret == null) {
            return 0;
        }
        return ret;
    }

    public long getResourceCount() {
        return this.accessCounter.keySet().stream().filter(handle -> handle.startsWith(this.resourcePrefix)).count();
    }

    public long getFileCount() {
        return this.accessCounter.keySet().stream().filter(handle -> !handle.startsWith(this.resourcePrefix)).count();
    }

    public Path toPath(Path handle) {
        Objects.requireNonNull(handle, "REQUIRE handle to access file or resource");
        return this.toPath(handle.toString());
    }

    public Path toPath(String handle) {
        Objects.requireNonNull(handle, "REQUIRE handle to access file or resource.");
        this.accessCounter.merge(handle, 1, Integer::sum);
        if (!handle.startsWith(this.resourcePrefix)) {
            return Paths.get(handle, new String[0]);
        }
        Path destination = this.mapper.get(handle);
        if (destination == null) {
            destination = KafuResource.asTempFile(handle.substring(this.resourcePrefix.length()));
            this.mapper.put(handle, destination);
        }
        return destination;
    }

    public String toString() {
        return String.format("%s '%s'; %d resources, %d files, %d cleanups, total access count: %d", this.getClass().getName(), this.resourcePrefix, this.getResourceCount(), this.getFileCount(), this.cleanUps, this.getAccessCount());
    }

    public String createStats() {
        StringBuilder create = new StringBuilder(this.toString());
        if (this.getResourceCount() == 0L) {
            create.append("\n").append("NO internal resources (marked with ").append(this.resourcePrefix).append(") used!");
        } else {
            create.append("\n").append("Resources (marked with ").append(this.resourcePrefix).append("):");
            this.accessCounter.forEach((handle, file) -> {
                if (handle.startsWith(this.resourcePrefix)) {
                    Path mappedTo = this.mapper.get(handle);
                    create.append(String.format("\n %s mapped to %s; %s", handle.substring(this.resourcePrefix.length()), mappedTo, KafuFile.sizeOfFile(mappedTo)));
                }
            });
        }
        if (this.getFileCount() == 0L) {
            create.append("\n").append("NO external files used!");
        } else {
            create.append("\n").append("External files:");
            this.accessCounter.forEach((handle, file) -> {
                if (!handle.startsWith(this.resourcePrefix)) {
                    create.append(String.format("\n %s %s", handle, KafuFile.sizeOfFile(handle)));
                }
            });
        }
        return create.toString();
    }
}

