/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.kafujo.io.KafuFile;
import net.kafujo.units.DataSize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KafuZip {
    private static final Logger lgr = LoggerFactory.getLogger(KafuZip.class);

    private KafuZip() {
    }

    public static void zipFile(Path in, Path out) {
        lgr.debug("About to zip file {} to {}", (Object)in.toAbsolutePath(), (Object)out.toAbsolutePath());
        KafuFile.requireNotDirectory(in);
        KafuFile.createFileOrUseEmpty(out);
        try (OutputStream outputStream = Files.newOutputStream(out, new OpenOption[0]);
             ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);){
            zipOutputStream.putNextEntry(new ZipEntry(in.getFileName().toString()));
            Files.copy(in, zipOutputStream);
            zipOutputStream.closeEntry();
            lgr.info("zipped {} from {} to {}", in, KafuFile.sizeOfFile(in), KafuFile.sizeOfFile(out));
        }
        catch (IOException e) {
            throw new UncheckedIOException("IO problem while zipping file: " + in.toAbsolutePath(), e);
        }
    }

    public static int zipDirectory(Path in, Path out) {
        long zippedSize;
        lgr.debug("About to zip directory {} to {}", (Object)in.toAbsolutePath(), (Object)out.toAbsolutePath());
        KafuFile.requireDirectory(in);
        KafuFile.createFileOrUseEmpty(out);
        int fileCount = 0;
        long unzippedSize = 0L;
        try (OutputStream outputStream = Files.newOutputStream(out, new OpenOption[0]);
             ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
             Stream<Path> pwalk = Files.walk(in, new FileVisitOption[0]);){
            Iterator it = pwalk.filter(path -> !Files.isDirectory(path, new LinkOption[0])).iterator();
            while (it.hasNext()) {
                Path current = (Path)it.next();
                unzippedSize += Files.size(current);
                ++fileCount;
                if (lgr.isTraceEnabled()) {
                    lgr.trace("Adding {} to {}", (Object)current, (Object)out);
                }
                ZipEntry zipEntry = new ZipEntry(in.relativize(current).toString());
                zipOutputStream.putNextEntry(zipEntry);
                Files.copy(current, zipOutputStream);
                zipOutputStream.closeEntry();
            }
            zippedSize = Files.size(out);
        }
        catch (IOException ioException) {
            throw new UncheckedIOException("IO problem while zipping directory " + in.toAbsolutePath(), ioException);
        }
        lgr.info("zipped {} files from {} to {}", fileCount, DataSize.of(unzippedSize), DataSize.of(zippedSize));
        return fileCount;
    }

    public static int zip(Path in, Path out) {
        KafuFile.requireExists(in);
        if (Files.isDirectory(in, new LinkOption[0])) {
            return KafuZip.zipDirectory(in, out);
        }
        KafuZip.zipFile(in, out);
        return 1;
    }

    public static int zip(String in, String out) {
        Objects.requireNonNull(in, "REQUIRE String in");
        Objects.requireNonNull(out, "REQUIRE String out");
        return KafuZip.zip(Paths.get(in, new String[0]), Paths.get(out, new String[0]));
    }

    public static Path zipToTempFile(String in) {
        Objects.requireNonNull(in, "REQUIRE String in");
        return KafuZip.zipToTempFile(Paths.get(in, new String[0]));
    }

    public static Path zipToTempFile(Path in) {
        Objects.requireNonNull(in, "REQUIRE in (path to be zipped)");
        Path out = KafuFile.createTempFile();
        KafuZip.zip(in, out);
        return out;
    }
}

