/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.container;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.kafujo.base.RequirementException;
import net.kafujo.io.KafuFile;
import net.kafujo.units.DataSize;

public class StringObjectMap
extends HashMap<String, Object>
implements AutoCloseable {
    private static final Queue<StringObjectMap> pool = new ConcurrentLinkedQueue<StringObjectMap>();
    private static int created = 0;
    private static int hits = 0;
    private static int fails = 0;
    private static int biggest = 0;

    private StringObjectMap() {
        super(23);
        ++created;
    }

    public static StringObjectMap poll() {
        StringObjectMap map = pool.poll();
        if (map == null) {
            ++fails;
            map = new StringObjectMap();
        } else {
            ++hits;
        }
        return map;
    }

    @Override
    public void close() {
        if (this.size() > biggest) {
            biggest = this.size();
        }
        this.clear();
        pool.add(this);
    }

    public static int getHits() {
        return hits;
    }

    public static int getFails() {
        return fails;
    }

    public static String stats() {
        return "StringObjectMap size: " + pool.size() + ", created: " + created + ", fails:" + fails + ", hits: " + hits;
    }

    public void putEnum(String key, Enum enumObj) {
        this.putEnum(key, enumObj, false);
    }

    public void putEnum(String key, Enum enumObj, boolean nullAllowed) {
        if (enumObj == null) {
            if (!nullAllowed) {
                throw new IllegalStateException("Null enum not allowed for Enum " + key);
            }
            this.put(key, null);
        } else {
            this.put(key, enumObj.name());
        }
    }

    public void putDataSize(String key, DataSize bytes) {
        this.putDataSize(key, bytes, false);
    }

    public void putDataSize(String key, DataSize dataSize, boolean nullAllowed) {
        if (dataSize == null) {
            if (!nullAllowed) {
                throw new RequirementException("Null value not allowed for DataSize " + key);
            }
            this.put(key, null);
        } else {
            this.put(key, dataSize.longValue());
        }
    }

    public void putPath(String key, Path path) {
        this.putPath(key, path, false);
    }

    public void putPath(String key, Path path, boolean nullAllowed) {
        if (path == null) {
            if (!nullAllowed) {
                throw new RequirementException("Null value not allowed for Path " + key);
            }
            this.put(key, null);
        } else {
            this.put(key, KafuFile.separatorsToUnix(path));
        }
    }
}

