/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class KafuCollection {
    private KafuCollection() {
    }

    public static Map<String, String> properties2StringMap(Properties props) {
        HashMap<String, String> map = new HashMap<String, String>(props.size());
        for (String key : props.stringPropertyNames()) {
            map.put(key, props.getProperty(key));
        }
        return map;
    }

    public static Properties stringMap2properties(Map<String, String> map) {
        Properties props = new Properties();
        for (String key : map.keySet()) {
            props.setProperty(key, map.get(key));
        }
        return props;
    }

    public static List<Integer> range(int endExclusive) {
        return KafuCollection.range(0, endExclusive, 1);
    }

    public static List<Integer> range(int startInclusive, int endExclusive) {
        return KafuCollection.range(startInclusive, endExclusive, 1);
    }

    public static List<Integer> range(int startInclusive, int endExclusive, int step) {
        if (startInclusive >= endExclusive) {
            throw new IllegalArgumentException("start must be smaller than end");
        }
        ArrayList<Integer> list = new ArrayList<Integer>((endExclusive - startInclusive) / step);
        for (int idx = startInclusive; idx < endExclusive; idx += step) {
            list.add(idx);
        }
        return list;
    }
}

