/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.config;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.List;
import net.kafujo.network.EmailAddress;
import net.kafujo.network.Host;
import net.kafujo.network.Hostname;
import net.kafujo.network.Port;
import net.kafujo.text.KafuText;
import net.kafujo.units.KafuDuration;

public interface TypedReader {
    public boolean isAvailable(CharSequence var1);

    public String readString(CharSequence var1);

    default public String readStringFbk(CharSequence key, CharSequence fbk) {
        if (this.isAvailable(key)) {
            return this.readString(key);
        }
        return fbk == null ? null : fbk.toString();
    }

    default public String readStringFbk(CharSequence key) {
        return this.readStringFbk(key, "N/A");
    }

    default public boolean readBoolean(CharSequence key) {
        String valueString = this.readString(key);
        if (valueString.equalsIgnoreCase("true")) {
            return true;
        }
        if (valueString.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException("key value for '" + key + "' MUST BE 'true' OR 'false'");
    }

    default public Boolean readBooleanFbk(CharSequence key, Boolean fbk) {
        if (this.isAvailable(key)) {
            return this.readBoolean(key);
        }
        return fbk;
    }

    default public short readShort(CharSequence key) {
        String valueString = this.readString(key);
        if (KafuText.equalsUniversalMin(valueString)) {
            return Short.MIN_VALUE;
        }
        if (KafuText.equalsUniversalMax(valueString)) {
            return Short.MAX_VALUE;
        }
        return Short.parseShort(valueString);
    }

    default public Short readShortFbk(CharSequence key, Short fbk) {
        if (this.isAvailable(key)) {
            return this.readShort(key);
        }
        return fbk;
    }

    default public int readInt(CharSequence key) {
        String valueString = this.readString(key);
        if (KafuText.equalsUniversalMin(valueString)) {
            return Integer.MIN_VALUE;
        }
        if (KafuText.equalsUniversalMax(valueString)) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(valueString);
    }

    default public Integer readIntFbk(CharSequence key, Integer fbk) {
        if (this.isAvailable(key)) {
            return this.readInt(key);
        }
        return fbk;
    }

    default public long readLong(CharSequence key) {
        String valueString = this.readString(key);
        if (KafuText.equalsUniversalMin(valueString)) {
            return Long.MIN_VALUE;
        }
        if (KafuText.equalsUniversalMax(valueString)) {
            return Long.MAX_VALUE;
        }
        return Long.parseLong(valueString);
    }

    default public Long readLongFbk(CharSequence key, Long fbk) {
        if (this.isAvailable(key)) {
            return this.readLong(key);
        }
        return fbk;
    }

    default public BigInteger readBigInteger(CharSequence key) {
        return new BigInteger(this.readString(key));
    }

    default public BigInteger readBigIntegerFbk(CharSequence key, BigInteger fbk) {
        String valueString = this.readStringFbk(key, null);
        if (valueString == null) {
            return fbk;
        }
        return new BigInteger(valueString);
    }

    default public Port readPort(CharSequence key) {
        return Port.of(this.readString(key));
    }

    default public Port readPortFbk(CharSequence key, Port fbk) {
        String valueString = this.readStringFbk(key, null);
        if (valueString == null) {
            return fbk;
        }
        return Port.of(valueString);
    }

    default public float readFloat(CharSequence key) {
        String valueString = this.readString(key);
        if (KafuText.equalsUniversalMin(valueString)) {
            return Float.MIN_VALUE;
        }
        if (KafuText.equalsUniversalMax(valueString)) {
            return Float.MAX_VALUE;
        }
        return Float.parseFloat(valueString);
    }

    default public Float readFloatFbk(CharSequence key, Float fbk) {
        if (this.isAvailable(key)) {
            return Float.valueOf(this.readFloat(key));
        }
        return fbk;
    }

    default public double readDouble(CharSequence key) {
        String valueString = this.readString(key);
        if (KafuText.equalsUniversalMin(valueString)) {
            return Double.MIN_VALUE;
        }
        if (KafuText.equalsUniversalMax(valueString)) {
            return Double.MAX_VALUE;
        }
        return Double.parseDouble(valueString);
    }

    default public Double readDoubleFbk(CharSequence key, Double fbk) {
        if (this.isAvailable(key)) {
            return this.readDouble(key);
        }
        return fbk;
    }

    default public BigDecimal readBigDecimal(CharSequence key) {
        return new BigDecimal(this.readString(key));
    }

    default public BigDecimal readBigDecimalFbk(CharSequence key, BigDecimal fbk) {
        String valueString = this.readStringFbk(key, null);
        if (valueString == null) {
            return fbk;
        }
        return new BigDecimal(valueString);
    }

    default public Duration readDurationOfMillis(String key) {
        return Duration.ofMillis(this.readLong(key));
    }

    default public Duration readDurationOfMillisFbk(String key, Duration fbk) {
        Long longValue = this.readLongFbk(key, null);
        if (longValue == null) {
            return fbk;
        }
        return Duration.ofMillis(longValue);
    }

    default public Duration readDurationOfMillisFbk(String key, Long fbk) {
        Long longValue = this.readLongFbk(key, null);
        if (longValue == null) {
            if (fbk == null) {
                return null;
            }
            return Duration.ofMillis(fbk);
        }
        return Duration.ofMillis(longValue);
    }

    default public Duration readDurationOfSeconds(String key) {
        return Duration.ofSeconds(this.readLong(key));
    }

    default public Duration readDurationOfSecondsFbk(String key, Duration fbk) {
        Long longValue = this.readLongFbk(key, null);
        if (longValue == null) {
            return fbk;
        }
        return Duration.ofSeconds(longValue);
    }

    default public Duration readDurationOfSecondsFbk(String key, Long fbk) {
        Long longValue = this.readLongFbk(key, null);
        if (longValue == null) {
            if (fbk == null) {
                return null;
            }
            return Duration.ofSeconds(fbk);
        }
        return Duration.ofSeconds(longValue);
    }

    default public Duration readDuration(CharSequence key) {
        String valueString = this.readString(key);
        if (KafuText.equalsUniversalMin(valueString)) {
            return KafuDuration.MIN_VALUE;
        }
        if (KafuText.equalsUniversalMax(valueString)) {
            return KafuDuration.MAX_VALUE;
        }
        return Duration.parse(valueString);
    }

    default public Duration readDurationFbk(CharSequence key, Duration fbk) {
        if (this.isAvailable(key)) {
            return this.readDuration(key);
        }
        return fbk;
    }

    default public URL readUrl(CharSequence key) {
        try {
            return new URL(this.readString(key));
        }
        catch (MalformedURLException fail) {
            throw new IllegalArgumentException(fail);
        }
    }

    default public URL readUrlFbk(CharSequence key, URL fbk) {
        String value = this.readStringFbk(key, null);
        if (value == null) {
            return fbk;
        }
        return this.readUrl(key);
    }

    default public EmailAddress readEmailAddress(CharSequence key) {
        return new EmailAddress(this.readString(key));
    }

    default public EmailAddress readEmailAddressFbk(CharSequence key, EmailAddress fbk) {
        String value = this.readStringFbk(key, null);
        if (value == null) {
            return fbk;
        }
        return this.readEmailAddress(key);
    }

    default public EmailAddress readEmailAddressFbk(CharSequence key, String fbk) {
        String value = this.readStringFbk(key, null);
        if (value == null) {
            if (fbk == null) {
                return null;
            }
            return new EmailAddress(fbk);
        }
        return this.readEmailAddress(key);
    }

    default public Hostname readHostname(CharSequence key) {
        return new Hostname(this.readString(key));
    }

    default public Hostname readHostnameFbk(CharSequence key, Hostname fbk) {
        String value = this.readStringFbk(key, null);
        if (value == null) {
            return fbk;
        }
        return this.readHostname(key);
    }

    default public Hostname readHostnameFbk(CharSequence key, String fbk) {
        String value = this.readStringFbk(key, null);
        if (value == null) {
            if (fbk == null) {
                return null;
            }
            return new Hostname(fbk);
        }
        return this.readHostname(key);
    }

    default public Host readHost(CharSequence key) {
        return new Host(this.readString(key));
    }

    default public Host readHostFbk(CharSequence key, Host fbk) {
        String value = this.readStringFbk(key, null);
        if (value == null) {
            return fbk;
        }
        return this.readHost(key);
    }

    default public Host readHostFbk(CharSequence key, String fbk) {
        String value = this.readStringFbk(key, null);
        if (value == null) {
            if (fbk == null) {
                return null;
            }
            return new Host(fbk);
        }
        return this.readHost(key);
    }

    default public Host readHostWithPort(CharSequence key) {
        Host host = new Host(this.readString(key));
        if (host.getPort().isEmpty()) {
            throw new IllegalArgumentException("Need a host with port but got only " + host);
        }
        return host;
    }

    default public Host readHostWithPortFbk(CharSequence key, Host fbk) {
        String value = this.readStringFbk(key, null);
        if (value == null) {
            if (fbk != null && fbk.getPort().isEmpty()) {
                throw new IllegalArgumentException("Need a fallback host with port but got only " + fbk);
            }
            return fbk;
        }
        return this.readHost(key);
    }

    default public Host readHostWithPortFbk(CharSequence key, String fbk) {
        String value = this.readStringFbk(key, null);
        if (value == null) {
            if (fbk == null) {
                return null;
            }
            Host host = new Host(fbk);
            if (host.getPort().isEmpty()) {
                throw new IllegalArgumentException("Need a fallback host with port but got only " + fbk);
            }
            return host;
        }
        return this.readHost(key);
    }

    default public Path readPath(CharSequence key) {
        return Paths.get(this.readString(key), new String[0]);
    }

    default public Path readPathFbk(CharSequence key, Path fbk) {
        String value = this.readStringFbk(key, null);
        if (value == null) {
            return fbk;
        }
        return Paths.get(value, new String[0]);
    }

    default public Path readPathFbk(CharSequence key, String fbk) {
        String value = this.readStringFbk(key, null);
        if (value == null) {
            if (fbk == null) {
                return null;
            }
            return Paths.get(fbk, new String[0]);
        }
        return Paths.get(value, new String[0]);
    }

    default public byte[] readFileToBytes(CharSequence key) {
        try {
            return Files.readAllBytes(this.readPath(key));
        }
        catch (IOException io) {
            throw new UncheckedIOException(io);
        }
    }

    default public String readFileToString(CharSequence key) {
        try {
            return Files.readString(this.readPath(key));
        }
        catch (IOException io) {
            throw new UncheckedIOException(io);
        }
    }

    default public List<String> readFileToLines(CharSequence key) {
        try {
            return Files.readAllLines(this.readPath(key));
        }
        catch (IOException io) {
            throw new UncheckedIOException(io);
        }
    }
}

