/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import net.kafujo.base.RequirementException;
import net.kafujo.config.PropertiesSource;
import net.kafujo.config.PropertiesSourceCollector;
import net.kafujo.config.TypedReader;
import net.kafujo.io.KafuFile;
import net.kafujo.io.KafuResource;

public class TypedProperties
extends Properties
implements TypedReader {
    private List<PropertiesSource> sources = new LinkedList<PropertiesSource>();

    public static PropertiesSourceCollector collectSources(PropertiesSource first, PropertiesSource ... sources) {
        return new PropertiesSourceCollector(first, sources);
    }

    public static TypedProperties load(PropertiesSource source) {
        Objects.requireNonNull(source, "REQUIRE source");
        if (!source.isAvailable()) {
            throw new IllegalArgumentException("Properties source is not available: " + source);
        }
        return source.load();
    }

    public static TypedProperties loadFile(String path) {
        Objects.requireNonNull(path, "REQUIRE path to property file as String");
        return TypedProperties.loadFile(Paths.get(path, new String[0]));
    }

    public static TypedProperties loadFile(Path path) {
        KafuFile.requireExists(path);
        TypedProperties tProps = new TypedProperties();
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            tProps.load(in);
            tProps.sources.add(PropertiesSource.ofFile(path.toAbsolutePath()));
        }
        catch (IOException trouble) {
            throw new UncheckedIOException(trouble);
        }
        return tProps;
    }

    public static TypedProperties loadFileXml(String path) {
        Objects.requireNonNull(path, "REQUIRE path to xml property file as String");
        return TypedProperties.loadFileXml(Paths.get(path, new String[0]));
    }

    public static TypedProperties loadFileXml(Path path) {
        KafuFile.requireExists(path);
        TypedProperties tProps = new TypedProperties();
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            tProps.loadFromXML(in);
            tProps.sources.add(PropertiesSource.ofFileXml(path.toAbsolutePath()));
        }
        catch (IOException trouble) {
            throw new UncheckedIOException(trouble);
        }
        return tProps;
    }

    public static TypedProperties loadResource(String name) {
        Objects.requireNonNull(name, "REQUIRE name of properties resource");
        return TypedProperties.loadResource(Paths.get(name, new String[0]));
    }

    public static TypedProperties loadResource(Path path) {
        TypedProperties tProps = new TypedProperties();
        Objects.requireNonNull(path, "REQUIRE path to properties resource");
        try (InputStream in = KafuResource.asStream(path.toString());){
            tProps.load(in);
            tProps.sources.add(PropertiesSource.ofResource(path));
        }
        catch (IOException trouble) {
            throw new UncheckedIOException(trouble);
        }
        return tProps;
    }

    public static TypedProperties loadResourceXml(String name) {
        Objects.requireNonNull(name, "REQUIRE name of xml properties resource");
        return TypedProperties.loadResourceXml(Paths.get(name, new String[0]));
    }

    public static TypedProperties loadResourceXml(Path path) {
        TypedProperties tProps = new TypedProperties();
        Objects.requireNonNull(path, "REQUIRE path to xml properties resource");
        try (InputStream in = KafuResource.asStream(path.toString());){
            tProps.loadFromXML(in);
            tProps.sources.add(PropertiesSource.ofResourceXml(path));
        }
        catch (IOException trouble) {
            throw new UncheckedIOException(trouble);
        }
        return tProps;
    }

    public TypedProperties() {
    }

    public TypedProperties(Properties takeOverProperties) {
        this.takeOver(takeOverProperties);
    }

    public void takeOver(Properties takeOver) {
        Objects.requireNonNull(takeOver, "REQUIRE takeOver Properties");
        takeOver.keySet().forEach((? super T key) -> this.put(key, takeOver.get(key)));
    }

    public void takeOver(PropertiesSource source) {
        this.takeOver(source.load());
        this.sources.add(source);
    }

    public String getLoadedInfo() {
        StringBuilder fileInfo = new StringBuilder("Sources: ").append(this.sources.size());
        for (PropertiesSource src : this.sources) {
            fileInfo.append("\n ").append(src);
        }
        return fileInfo.toString();
    }

    @Override
    public boolean isAvailable(CharSequence key) {
        Objects.requireNonNull(key, "REQUIRE key");
        return this.get(key.toString()) != null;
    }

    @Override
    public String readString(CharSequence key) {
        Objects.requireNonNull(key, "REQUIRE key");
        Object value = this.get(key.toString());
        if (value == null) {
            throw new RequirementException("There is no value for key: " + key);
        }
        return value.toString();
    }

    @Override
    public String readStringFbk(CharSequence key, CharSequence fbk) {
        Objects.requireNonNull(key, "REQUIRE key");
        Object value = this.get(key.toString());
        if (value != null) {
            return value.toString();
        }
        return fbk == null ? null : fbk.toString();
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        Objects.requireNonNull(key, "REQUIRE key");
        if (!(key instanceof CharSequence)) {
            throw new IllegalArgumentException("key must be a CharSequence");
        }
        Objects.requireNonNull(value, "REQUIRE value");
        return super.put(key.toString(), value.toString());
    }

    public Path store(String comments) {
        return this.store(comments, KafuFile.createTempFile());
    }

    public Path store(String comments, Path path) {
        try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
            super.store(out, comments);
        }
        catch (IOException trouble) {
            throw new UncheckedIOException(trouble);
        }
        return path;
    }

    public Path storeToXml(String comments) {
        return this.storeToXml(comments, KafuFile.createTempFile());
    }

    public Path storeToXml(String comments, Path path) {
        try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
            super.storeToXML(out, comments);
        }
        catch (IOException trouble) {
            throw new UncheckedIOException(trouble);
        }
        return path;
    }

    @Override
    public synchronized String toString() {
        StringBuilder builder = new StringBuilder(this.size() + " Properties");
        if (!this.sources.isEmpty()) {
            builder.append("; initially loaded from ").append(this.getLoadedInfo());
        }
        LinkedList<String> sort = new LinkedList<String>(this.stringPropertyNames());
        Collections.sort(sort);
        for (String key : sort) {
            builder.append(String.format("\n  %37s = %s", key, this.readString(key)));
        }
        return builder.toString();
    }

    public static void main(String[] args) {
        TypedProperties tp2 = TypedProperties.collectSources(PropertiesSource.ofFileXml("/b/res/types.xml"), PropertiesSource.ofFile("/b/res/types.properties")).useFirstAvailable();
        System.out.println(tp2.toString());
    }
}

