/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.config;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.kafujo.base.RequirementException;
import org.apache.commons.lang3.StringUtils;

public enum SystemProperty {
    JAVA_VERSION("java.version"),
    JAVA_VERSION_DATE("java.version.date"),
    JAVA_VENDOR("java.vendor"),
    JAVA_VENDOR_URL("java.vendor.url"),
    JAVA_VENDOR_URL_BUG("java.vendor.url.bug"),
    JAVA_VENDOR_VERSION("java.vendor.version"),
    JAVA_SPECIFICATION_VENDOR("java.specification.vendor"),
    JAVA_RUNTIME_VERSION("java.runtime.version"),
    JAVA_RUNTIME_NAME("java.runtime.name"),
    JAVA_SPECIFICATION_VERSION("java.specification.version"),
    JAVA_SPECIFICATION_NAME("java.specification.name"),
    JAVA_CLASS_VERSION("java.class.version"),
    VM_NAME("java.vm.name"),
    VM_INFO("java.vm.info"),
    VM_VERSION("java.vm.version"),
    VM_VENDOR("java.vm.vendor"),
    VM_SPECIFICATION_VERSION("java.vm.specification.version"),
    VM_SPECIFICATION_NAME("java.vm.specification.name"),
    VM_SPECIFICATION_VENDOR("java.vm.specification.vendor"),
    VM_COMPRESSEDOOPSMODE("java.vm.compressedOopsMode"),
    JDK_DEBUG("jdk.debug"),
    AWT_TOOLKIT("awt.toolkit"),
    SUN_AWT_GRAPHICSENV("java.awt.graphicsenv"),
    SUN_AWT_PRINTERJOB("java.awt.printerjob"),
    SUN_CPU_ISALIST("sun.cpu.isalist"),
    SUN_JNU_ENCODING("sun.jnu.encoding"),
    SUN_ARCH_DATA_MODEL("sun.arch.data.model"),
    SUN_OS_PATCH_LEVEL("sun.os.patch.level"),
    SUN_CPU_ENDIAN("sun.cpu.endian"),
    SUN_JAVA_COMMAND("sun.java.command"),
    SUN_JAVA_LAUNCHER("sun.java.launcher"),
    SUN_BOOT_LIBRARY_PATH("sun.boot.library.path"),
    SUN_MANAGEMENT_COMPILER("sun.management.compiler"),
    SUN_IO_UNICODE_ENCODING("sun.io.unicode.encoding"),
    SUN_DESKTOP("sun.desktop"),
    OS_NAME("os.name"),
    OS_VERSION("os.version"),
    OS_ARCH("os.arch"),
    FILE_ENCODING("file.encoding"),
    FILE_SEPARATOR("file.separator"),
    LINE_SEPARATOR("line.separator"),
    PATH_SEPARATOR("path.separator"),
    JAVA_IO_TMPDIR("java.io.tmpdir"),
    JAVA_HOME("java.home"),
    JAVA_CLASS_PATH("java.class.path"),
    JAVA_LIBRARY_PATH("java.library.path"),
    USER_NAME("user.name"),
    USER_COUNTRY("user.country"),
    USER_TIMEZONE("user.timezone"),
    USER_LANGUAGE("user.language"),
    USER_HOME("user.home"),
    USER_DIR("user.dir"),
    USER_SCRIPT("user.script"),
    USER_VARIANT("user.variant"),
    JMXREMOTE("com.sun.management.jmxremote"),
    JMXREMOTE_PORT("com.sun.management.jmxremote.port"),
    JMXREMOTE_RMI_PORT("com.sun.management.jmxremote.rmi.port"),
    JMXREMOTE_LOCAL_ONLY("com.sun.management.jmxremote.local.only"),
    JMXREMOTE_SSL("com.sun.management.jmxremote.ssl"),
    JMXREMOTE_AUTHENTICATE("com.sun.management.jmxremote.authenticate"),
    JMXREMOTE_LOGIN_CONFIG("com.sun.management.jmxremote.login.config"),
    JMXREMOTE_PASSWORD_FILE("com.sun.management.jmxremote.password.file"),
    JMXREMOTE_REGISTRY_SSL("com.sun.management.jmxremote.registry.ssl"),
    JMXREMOTE_SSL_NEED_CLIENT_AUTH("com.sun.management.jmxremote.ssl.need.client.auth"),
    SSL_KEYSTORE("javax.net.ssl.keyStore"),
    SSL_KEYSTORE_TYPE("javax.net.ssl.keyStoreType"),
    SSL_KEYSTORE_PASSWORD("javax.net.ssl.keyStorePassword"),
    SSL_TRUSTSTORE("javax.net.ssl.trustStore"),
    SSL_TRUSTSTORE_TYPE("javax.net.ssl.trustStoreType"),
    SSL_TRUSTSTORE_PASSWORD("javax.net.ssl.trustStorePassword");

    public final String key;
    public static final Comparator<SystemProperty> COMPARE_BY_KEY;
    private static final SortedSet<SystemProperty> LISTED;

    private SystemProperty(String key) {
        this.key = Objects.requireNonNull(key);
    }

    public static boolean isAvailable(String key) {
        Objects.requireNonNull(key, "REQUIRE system property key");
        return System.getProperty(key) != null;
    }

    public boolean isAvailable() {
        return System.getProperty(this.key) != null;
    }

    public boolean isNotAvailable() {
        return System.getProperty(this.key) == null;
    }

    public String requireAvailability() {
        String value = System.getProperty(this.key);
        if (value == null) {
            throw new RequirementException("NO VALUE FOR REQUIRED SYSTEM PROPERTY '" + this.key + "'");
        }
        return value;
    }

    public static String requireAvailability(String key) {
        Objects.requireNonNull(key, "REQUIRE system property key");
        String value = System.getProperty(key);
        if (value == null) {
            throw new RequirementException("NO VALUE FOR REQUIRED SYSTEM PROPERTY '" + key + "'");
        }
        return value;
    }

    public static String asString(String key) {
        return SystemProperty.requireAvailability(key);
    }

    public String asString() {
        return SystemProperty.asString(this.key);
    }

    public static String asStringFbk(String key, String fbk) {
        return SystemProperty.isAvailable(key) ? System.getProperty(key) : fbk;
    }

    public String asStringFbk(String fbk) {
        return SystemProperty.asStringFbk(this.key, fbk);
    }

    public String asStringFbk() {
        return SystemProperty.asStringFbk(this.key, this.key + " N/A");
    }

    public static boolean asBoolean(String name) {
        String val = SystemProperty.requireAvailability(name);
        if (val.equalsIgnoreCase("true")) {
            return true;
        }
        if (val.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException("SYSTEM PROPERTY '" + name + "' MUST BE 'true' OR 'false'");
    }

    public boolean asBoolean() {
        return SystemProperty.asBoolean(this.key);
    }

    public static Boolean asBooleanFbk(String key, Boolean fbk) {
        if (SystemProperty.isAvailable(key)) {
            return SystemProperty.asBoolean(key);
        }
        return fbk;
    }

    public boolean asBooleanFbk(Boolean fbk) {
        return SystemProperty.asBooleanFbk(this.key, fbk);
    }

    public static long asLong(String key) {
        String val = SystemProperty.requireAvailability(key);
        return Long.parseLong(val);
    }

    public long asLong() {
        return SystemProperty.asLong(this.key);
    }

    public static Long asLongFbk(String key, Long fbk) {
        if (SystemProperty.isAvailable(key)) {
            return SystemProperty.asLong(key);
        }
        return fbk;
    }

    public Long asLongFbk(Long fbk) {
        return SystemProperty.asLongFbk(this.key, fbk);
    }

    public static int asInteger(String key) {
        String val = SystemProperty.requireAvailability(key);
        return Integer.parseInt(val);
    }

    public int asInteger() {
        return SystemProperty.asInteger(this.key);
    }

    public static Integer asIntegerFbk(String key, Integer fbk) {
        if (SystemProperty.isAvailable(key)) {
            return SystemProperty.asInteger(key);
        }
        return fbk;
    }

    public Integer asIntegerFbk(Integer fbk) {
        return SystemProperty.asIntegerFbk(this.key, fbk);
    }

    public static Path asPath(String key) {
        return Paths.get(SystemProperty.asString(key), new String[0]);
    }

    public Path asPath() {
        return SystemProperty.asPath(this.key);
    }

    public static Path asPathFbk(String key, Path fbk) {
        return SystemProperty.isAvailable(key) ? SystemProperty.asPath(key) : fbk;
    }

    public Path asPath(Path fbk) {
        return SystemProperty.asPathFbk(this.key, fbk);
    }

    public String toString() {
        return this.key + " = " + this.asStringFbk("N/A");
    }

    public String toString(int maxLen) {
        return StringUtils.abbreviate(this.toString(), maxLen);
    }

    public static SortedSet<String> getKeysAvailable() {
        return System.getProperties().keySet().stream().map(Object::toString).collect(Collectors.toCollection(TreeSet::new));
    }

    public static SortedSet<String> getKeysAvailableNotListed() {
        SortedSet<String> total = SystemProperty.getKeysAvailable();
        SystemProperty.getListed().forEach(e -> total.remove(e.key));
        return total;
    }

    public static Set<SystemProperty> getListed() {
        return LISTED;
    }

    public static SortedSet<SystemProperty> getListedAvailable() {
        return LISTED.stream().filter(SystemProperty::isAvailable).collect(Collectors.toCollection(() -> new TreeSet<SystemProperty>(COMPARE_BY_KEY)));
    }

    public static SortedSet<SystemProperty> getListedNotAvailable() {
        return LISTED.stream().filter(SystemProperty::isNotAvailable).collect(Collectors.toCollection(() -> new TreeSet<SystemProperty>(COMPARE_BY_KEY)));
    }

    public static String combine(String ... keys) {
        StringBuilder tmp = new StringBuilder(System.getProperty(keys[0]));
        for (int i = 1; i < keys.length; ++i) {
            Object val = System.getProperty(keys[i]);
            if (StringUtils.isBlank((CharSequence)val)) {
                val = keys[i] + " N/A";
            }
            tmp.append(" | ").append((String)val);
        }
        return tmp.toString();
    }

    public static String combine(SystemProperty ... props) {
        String[] tmp = new String[props.length];
        for (int idx = 0; idx < tmp.length; ++idx) {
            tmp[idx] = props[idx].key;
        }
        return SystemProperty.combine(tmp);
    }

    public static String combineOsInfo() {
        String tmp = OS_NAME.asStringFbk() + " " + OS_VERSION.asStringFbk();
        if (!StringUtils.isBlank(OS_ARCH.asStringFbk(""))) {
            return tmp + " (" + OS_ARCH.asString() + ")";
        }
        return tmp;
    }

    public static String combineVmInfo() {
        return VM_NAME.asStringFbk() + " " + VM_VERSION.asStringFbk() + " (" + VM_INFO.asStringFbk() + ")";
    }

    public static String combineJmxFull() {
        Object build = "";
        if (JMXREMOTE.isAvailable()) {
            build = (String)build + "jmx.remote='" + JMXREMOTE.asString() + "'; ";
        }
        if (JMXREMOTE_PORT.isAvailable()) {
            build = (String)build + "port=" + JMXREMOTE_PORT.asString() + "; ";
        }
        if (JMXREMOTE_RMI_PORT.isAvailable()) {
            build = (String)build + "rmi.port=" + JMXREMOTE_RMI_PORT.asString() + "; ";
        }
        if (JMXREMOTE_LOCAL_ONLY.isAvailable()) {
            build = (String)build + "local.only=" + JMXREMOTE_LOCAL_ONLY.asString() + "; ";
        }
        if (JMXREMOTE_SSL.isAvailable()) {
            build = (String)build + "ssl=" + JMXREMOTE_SSL.asString() + "; ";
        }
        if (JMXREMOTE_REGISTRY_SSL.isAvailable()) {
            build = (String)build + "registry.ssl=" + JMXREMOTE_REGISTRY_SSL.asString() + "; ";
        }
        if (JMXREMOTE_SSL_NEED_CLIENT_AUTH.isAvailable()) {
            build = (String)build + "ssl.need.client.auth=" + JMXREMOTE_SSL_NEED_CLIENT_AUTH.asString() + "; ";
        }
        if (JMXREMOTE_AUTHENTICATE.isAvailable()) {
            build = (String)build + "auth=" + JMXREMOTE_AUTHENTICATE.asString() + "; ";
        }
        if (JMXREMOTE_PASSWORD_FILE.isAvailable()) {
            build = (String)build + "pwfile=" + JMXREMOTE_PASSWORD_FILE.asString() + "; ";
        }
        if (JMXREMOTE_LOGIN_CONFIG.isAvailable()) {
            build = (String)build + "login.config=" + JMXREMOTE_LOGIN_CONFIG.asString() + "; ";
        }
        if (StringUtils.isBlank((CharSequence)build)) {
            build = "N/A";
        }
        return build;
    }

    public static String combineJmxPorts() {
        Object build = "";
        if (JMXREMOTE_PORT.isAvailable()) {
            build = (String)build + JMXREMOTE_PORT.asString();
        }
        if (JMXREMOTE_RMI_PORT.isAvailable()) {
            build = (String)build + " (rmi " + JMXREMOTE_RMI_PORT.asString() + ")";
        }
        if (StringUtils.isBlank((CharSequence)build)) {
            return "N/A";
        }
        return ((String)build).trim();
    }

    public static String combineUserInfo() {
        return USER_NAME.asStringFbk() + " (" + SystemProperty.createUserLocaleFbk("N/A", "N/A") + "); dir=" + USER_DIR.asStringFbk() + "; home=" + USER_HOME.asStringFbk();
    }

    public static Locale createUserLocale() {
        return new Locale(USER_LANGUAGE.asString(), USER_COUNTRY.asString());
    }

    public static Locale createUserLocaleFbk(String language, String country) {
        return new Locale(USER_LANGUAGE.asStringFbk(language), USER_COUNTRY.asStringFbk(country));
    }

    public static Locale createUserLocaleFbk() {
        return SystemProperty.createUserLocaleFbk("en", "");
    }

    static {
        COMPARE_BY_KEY = Comparator.comparing(sp -> sp.key);
        LISTED = Collections.unmodifiableSortedSet(Arrays.stream(SystemProperty.values()).collect(Collectors.toCollection(() -> new TreeSet<SystemProperty>(COMPARE_BY_KEY))));
    }
}

