/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.config;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.kafujo.config.PropertiesSource;
import net.kafujo.config.TypedProperties;

public class PropertiesSourceCollector {
    private final List<PropertiesSource> available = new LinkedList<PropertiesSource>();
    private final List<PropertiesSource> notAvailable = new LinkedList<PropertiesSource>();

    public PropertiesSourceCollector(PropertiesSource first, PropertiesSource ... sources) {
        Objects.requireNonNull(first, "REQUIRE (at least one) PropertiesSource ");
        this.checkAndAdd(first);
        for (PropertiesSource source : sources) {
            this.checkAndAdd(source);
        }
        if (this.available.isEmpty()) {
            throw new IllegalArgumentException("None of the " + this.notAvailable.size() + " given Properties Sources are actually available: " + this.notAvailable);
        }
    }

    private void checkAndAdd(PropertiesSource source) {
        if (this.available.contains(source)) {
            throw new IllegalArgumentException("Property file of " + source + " is already collected: " + this.available);
        }
        if (source.isAvailable()) {
            this.available.add(source);
        } else {
            this.notAvailable.add(source);
        }
    }

    public TypedProperties useFirstAvailable() {
        return this.available.get(0).load();
    }

    public TypedProperties merge() {
        TypedProperties mergedProps = this.useFirstAvailable();
        if (this.available.size() == 1) {
            return mergedProps;
        }
        for (PropertiesSource source : this.available.subList(1, this.available.size())) {
            mergedProps.takeOver(source);
        }
        return mergedProps;
    }

    public List<PropertiesSource> getAvailableSources() {
        return Collections.unmodifiableList(this.available);
    }
}

