/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.config;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import net.kafujo.config.TypedProperties;
import net.kafujo.io.KafuResource;

public class PropertiesSource {
    private static int COUNT = 0;
    private final int count = ++COUNT;
    private final boolean resource;
    private final boolean xml;
    private final Path path;

    public static PropertiesSource ofFile(Path path) {
        return new PropertiesSource(path, false, false);
    }

    public static PropertiesSource ofFileXml(Path path) {
        return new PropertiesSource(path, false, true);
    }

    public static PropertiesSource ofFile(String path) {
        return new PropertiesSource(path, false, false);
    }

    public static PropertiesSource ofFileXml(String path) {
        return new PropertiesSource(path, false, true);
    }

    public static PropertiesSource ofResource(String path) {
        return new PropertiesSource(path, true, false);
    }

    public static PropertiesSource ofResource(Path path) {
        return new PropertiesSource(path, true, false);
    }

    public static PropertiesSource ofResourceXml(Path path) {
        return new PropertiesSource(path, true, true);
    }

    public static PropertiesSource ofResourceXml(String path) {
        return new PropertiesSource(path, true, true);
    }

    private PropertiesSource(String path, boolean resource, boolean xml) {
        this(path == null ? (Path)null : Paths.get(path, new String[0]), resource, xml);
    }

    private PropertiesSource(Path path, boolean resource, boolean xml) {
        this.resource = resource;
        this.xml = xml;
        this.path = path;
    }

    public boolean isAvailable() {
        if (this.path == null) {
            return false;
        }
        return this.resource ? KafuResource.isAvailable(this.path.toString()) : Files.exists(this.path, new LinkOption[0]);
    }

    public TypedProperties load() {
        if (!this.isAvailable()) {
            throw new IllegalStateException("Source cannot be loaded cause its not available: " + this);
        }
        if (this.resource) {
            return this.xml ? TypedProperties.loadResourceXml(this.path) : TypedProperties.loadResource(this.path);
        }
        return this.xml ? TypedProperties.loadFileXml(this.path) : TypedProperties.loadFile(this.path);
    }

    public String toString() {
        Object xmlStr;
        Object object = xmlStr = this.xml ? "' (xml)" : "' (properties)";
        if (!this.isAvailable()) {
            xmlStr = (String)xmlStr + " *** N/A ***";
        }
        if (this.resource) {
            return "[" + this.count + "] RESOURCE '" + this.path + (String)xmlStr;
        }
        return "[" + this.count + "] FILE '" + this.path + (String)xmlStr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertiesSource that = (PropertiesSource)o;
        return this.resource == that.resource && this.xml == that.xml && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.resource, this.xml, this.path);
    }
}

