/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.config;

import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.Instant;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.kafujo.base.RequirementException;
import net.kafujo.config.SystemProperty;
import net.kafujo.units.DataSize;
import net.kafujo.units.KafuDateTime;
import net.kafujo.units.KafuDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KafuVm {
    private static Logger lgr = LoggerFactory.getLogger(KafuVm.class);
    private static final Instant VM_STARTED = Instant.ofEpochMilli(ManagementFactory.getRuntimeMXBean().getStartTime());

    private KafuVm() {
    }

    public static Locale getDefaultLocale() {
        Locale locale = Locale.getDefault();
        if (locale == null) {
            lgr.info("UNEXPECTED: Locale.getDefault() == null");
            throw new RequirementException("Locale.getDefault() == null");
        }
        return locale;
    }

    public static String getDefaultLanguage() {
        String lang = KafuVm.getDefaultLocale().getLanguage();
        if (lang == null) {
            lgr.info("UNEXPECTED: Locale.getDefault().getDefaultLanguage() == null");
            throw new RequirementException("Locale.getDefault().getDefaultLanguage() == null");
        }
        return lang;
    }

    public static Locale getDefaultLocaleFbk(Locale fbk) {
        Locale locale = Locale.getDefault();
        if (locale == null) {
            return fbk;
        }
        return locale;
    }

    public static String getLanguageFbk(Locale locale, String fbk) {
        if (locale != null && locale.getLanguage() != null) {
            return locale.getLanguage();
        }
        return fbk;
    }

    public static String getDefaultLanguageFbk(String fbk) {
        Objects.requireNonNull(fbk, "REQUIRE fallback");
        Locale locale = Locale.getDefault();
        if (locale != null && locale.getLanguage() != null) {
            return locale.getLanguage();
        }
        return fbk;
    }

    public static String getInfoLocale() {
        return "default: " + KafuVm.getDefaultLocaleFbk(new Locale("N/A")) + " (user system properties: " + SystemProperty.createUserLocaleFbk("N/A", "N/A") + ")";
    }

    public static DataSize getMaxMemory() {
        return DataSize.of(Runtime.getRuntime().maxMemory());
    }

    public static DataSize getFreeMemory() {
        return DataSize.of(Runtime.getRuntime().freeMemory());
    }

    public static DataSize getTotalMemory() {
        return DataSize.of(Runtime.getRuntime().totalMemory());
    }

    public static String getInfo() {
        return SystemProperty.combineVmInfo() + " [PID=" + KafuVm.getProcessPid() + "]";
    }

    public static String getInfoAndUptime() {
        return SystemProperty.combineVmInfo() + " [PID=" + KafuVm.getProcessPid() + "] up since " + KafuDuration.adaptUnits(KafuVm.getUptime());
    }

    public static String getInfoAndStarted() {
        return SystemProperty.combineVmInfo() + " [PID=" + KafuVm.getProcessPid() + "] up since " + KafuDateTime.full(VM_STARTED);
    }

    public static Instant getStarted() {
        return VM_STARTED;
    }

    public static Duration getUptime() {
        return Duration.between(VM_STARTED, Instant.now());
    }

    public static long getProcessPid() {
        return ProcessHandle.current().pid();
    }

    public static String getProcessInfo() {
        Optional<String> user;
        ProcessHandle.Info info = ProcessHandle.current().info();
        Object val = "VM Process started ";
        Optional<Instant> started = info.startInstant();
        if (started.isPresent()) {
            val = (String)val + KafuDateTime.full(started.get());
        }
        val = (user = info.user()).isPresent() ? (String)val + " by " + user.get() : (String)val + " by N/A";
        Optional<Duration> cpu = info.totalCpuDuration();
        if (cpu.isPresent()) {
            val = (String)val + " (" + KafuDuration.adaptUnits(cpu.get()) + " total cpu duration by uptime of " + KafuDuration.adaptUnits(KafuVm.getUptime()) + ")";
        }
        return val;
    }

    public static String getMemoryInfo() {
        DataSize total = KafuVm.getTotalMemory();
        DataSize max = KafuVm.getMaxMemory();
        BigDecimal percentage = total.toBigDecimal().multiply(BigDecimal.valueOf(100L)).divide(max.toBigDecimal(), RoundingMode.FLOOR);
        return String.format("%s free; %s total; %s max; %s%% of available memory allocated", KafuVm.getFreeMemory(), total, max, percentage.setScale(2, RoundingMode.FLOOR));
    }

    public static void main(String[] args) {
        System.out.println(KafuVm.getMemoryInfo());
    }
}

