/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.config;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.kafujo.config.SystemProperty;
import net.kafujo.io.KafuInput;
import net.kafujo.units.KafuDateTime;
import net.kafujo.units.KafuDuration;
import org.apache.commons.lang3.StringUtils;

public final class KafuOs {
    private KafuOs() {
    }

    public static String execute(Path command, String ... options) {
        Objects.requireNonNull(command, "REQUIRE command to execute");
        ArrayList<String> list = new ArrayList<String>(options.length + 1);
        list.add(command.toString());
        list.addAll(Arrays.asList(options));
        return KafuOs.execute(list);
    }

    public static String execute(List<String> commandAndOptions) {
        Objects.requireNonNull(commandAndOptions, "REQUIRE command (and options");
        StringBuilder sb = new StringBuilder();
        try {
            ProcessBuilder pb = new ProcessBuilder(commandAndOptions);
            Process p = pb.start();
            String stdout = KafuInput.asString(p.getInputStream());
            String stderr = KafuInput.asString(p.getErrorStream());
            if (!StringUtils.isBlank(stdout)) {
                sb.append('\n').append(stdout);
            }
            if (!StringUtils.isBlank(stderr)) {
                sb.append("\n\n").append(StringUtils.leftPad(" STDERR:", 100, "> ")).append('\n').append(stderr);
            }
        }
        catch (IOException | RuntimeException ioAndRt) {
            sb.append("\n\n").append(StringUtils.leftPad(" " + ioAndRt.getClass().getName() + ":", 100, "> ")).append('\n');
            if (ioAndRt.getMessage() != null) {
                sb.append(ioAndRt.getMessage());
            }
            sb.append(ioAndRt);
        }
        return sb.toString();
    }

    public static String executePretty(List<String> commandAndOptions) {
        Objects.requireNonNull(commandAndOptions, "REQUIRE commandAndOptions");
        if (commandAndOptions.isEmpty()) {
            throw new IllegalStateException("command cannot be empty");
        }
        LocalDateTime now = LocalDateTime.now();
        StringBuilder sb = new StringBuilder(StringUtils.leftPad(" " + KafuDateTime.full(now) + "  EXECUTE OS COMMAND", 100, "> ")).append("\n> ").append(commandAndOptions.get(0));
        for (int idx = 1; idx < commandAndOptions.size(); ++idx) {
            sb.append(' ').append(commandAndOptions.get(idx));
        }
        sb.append('\n').append(KafuOs.execute(commandAndOptions));
        String took = KafuDuration.adaptUnits(Duration.between(now, LocalDateTime.now()));
        String done = " EXECUTED '" + commandAndOptions.get(0) + "'  " + took;
        sb.append("\n\n").append(StringUtils.leftPad(done, 100, "< ")).append("\n\n");
        return sb.toString();
    }

    public static String executePretty(String command) {
        Objects.requireNonNull(command, "REQUIRE command to execute");
        return KafuOs.executePretty(Arrays.asList(command.split(" ")));
    }

    public static boolean isWindows() {
        String osName = SystemProperty.OS_NAME.asString();
        return osName.toLowerCase().contains("windows");
    }
}

