/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.config;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import net.kafujo.base.RequirementException;
import net.kafujo.config.ConfigProperty;
import net.kafujo.config.ConfigPropertySource;
import net.kafujo.container.KafuCollection;

public class ConfigPropertyManager {
    private final Map<String, ConfigProperty> propertyMap = new TreeMap<String, ConfigProperty>();
    private final String keyPrefix;

    public static ConfigPropertyManager fromProperties(Properties props, String keyPrefix) {
        return new ConfigPropertyManager(props, keyPrefix);
    }

    private ConfigPropertyManager(Properties props, String keyPrefix) {
        this.keyPrefix = keyPrefix;
        this.createAndRegisterFileProps(props);
        Properties probsEnv = KafuCollection.stringMap2properties(System.getenv());
        this.createAndRegisterProps(probsEnv, ConfigPropertySource.ENV);
        this.createAndRegisterProps(System.getProperties(), ConfigPropertySource.SYS);
    }

    private void createAndRegisterFileProps(Properties props) {
        for (String key : props.stringPropertyNames()) {
            this.register(new ConfigProperty(key, props.getProperty(key), ConfigPropertySource.PROP));
        }
    }

    private void createAndRegisterProps(Properties properties, ConfigPropertySource source) {
        Iterator<String> iterator = properties.stringPropertyNames().iterator();
        while (iterator.hasNext()) {
            ConfigProperty cp;
            String key;
            String keyWithoutPrefix = key = iterator.next();
            if (this.keyPrefix != null) {
                if (!key.startsWith(this.keyPrefix)) continue;
                keyWithoutPrefix = key.substring(this.keyPrefix.length());
            }
            if ((cp = this.propertyMap.get(keyWithoutPrefix)) != null) {
                cp.setValue(properties.getProperty(key), source);
                continue;
            }
            this.register(new ConfigProperty(keyWithoutPrefix, properties.getProperty(key), source));
        }
    }

    private void register(ConfigProperty property) {
        if (this.propertyMap.containsKey(property.getKey())) {
            throw new IllegalStateException(property + ": key is already registerd");
        }
        this.propertyMap.put(property.getKey(), property);
    }

    public String read(String key) {
        ConfigProperty property = this.propertyMap.get(key);
        if (property == null) {
            throw new RequirementException("No config property for key: " + key);
        }
        return property.readValue();
    }

    private ConfigProperty getPropertyOrThrow(String key) {
        ConfigProperty property = this.propertyMap.get(key);
        if (property == null) {
            throw new RequirementException("No config property for key: " + key);
        }
        return property;
    }

    public synchronized String read(String key, String defaultValue) {
        ConfigProperty property = this.propertyMap.get(key);
        if (property == null) {
            property = new ConfigProperty(key, defaultValue);
            this.register(property);
        }
        return property.readValue();
    }

    public long getReadCounter(String key) {
        return this.getPropertyOrThrow(key).getReadCounter();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String key : this.propertyMap.keySet()) {
            sb.append(this.propertyMap.get(key)).append(System.lineSeparator());
        }
        return sb.toString();
    }
}

