/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.config;

import java.time.LocalDateTime;
import java.util.EnumMap;
import java.util.Objects;
import net.kafujo.config.ConfigPropertySource;

class ConfigProperty {
    private final EnumMap<ConfigPropertySource, String> sources = new EnumMap(ConfigPropertySource.class);
    private final LocalDateTime registered = LocalDateTime.now();
    private final String key;
    private String value;
    private ConfigPropertySource source;
    private long readCounter = 0L;

    ConfigProperty(String key, String value, ConfigPropertySource source) {
        this.key = Objects.requireNonNull(key, "ConfigProperty key cannot be null");
        this.value = Objects.requireNonNull(value, "ConfigProperty value cannot be null");
        this.source = Objects.requireNonNull(source, "ConfigProperty source cannot be null");
        this.sources.put(source, value);
    }

    ConfigProperty(String key, String value) {
        this(key, value, ConfigPropertySource.SRC);
    }

    void setValue(String value, ConfigPropertySource source) {
        if (this.sources.containsKey((Object)source)) {
            throw new IllegalArgumentException("Source " + source + " + has already a value: " + this.sources.get((Object)source));
        }
        this.value = Objects.requireNonNull(value, "ConfigProperty value cannot be null");
        this.source = Objects.requireNonNull(source, "ConfigProperty source cannot be null");
        this.sources.put(source, value);
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String readValue() {
        ++this.readCounter;
        return this.value;
    }

    public ConfigPropertySource getSource() {
        return this.source;
    }

    public long getReadCounter() {
        return this.readCounter;
    }

    public LocalDateTime getRegistered() {
        return this.registered;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigProperty property = (ConfigProperty)o;
        return Objects.equals(this.key, property.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public String toString() {
        return String.format("%-11s %3d reads: %s = %s", this.sources.keySet(), this.readCounter, this.key, this.value);
    }
}

