/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.base;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Objects;

public final class KafuException {
    private KafuException() {
    }

    public static String extractMessage(Throwable throwable) {
        Objects.requireNonNull(throwable, "REQUIRE throwable");
        String message = throwable.getMessage();
        if (message == null || message.isBlank()) {
            return throwable.toString();
        }
        return message;
    }

    public static String extractClassAndMessage(Throwable throwable) {
        Objects.requireNonNull(throwable, "REQUIRE throwable");
        String message = throwable.getMessage();
        if (message == null || message.isBlank()) {
            return throwable.toString();
        }
        return throwable.getClass().getSimpleName() + ": " + message;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String extractStackTrace(Throwable throwable) {
        try (StringWriter sw = new StringWriter();){
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            try {
                throwable.printStackTrace(pw);
                String string = sw.getBuffer().toString();
                pw.close();
                return string;
            }
            catch (Throwable throwable2) {
                try {
                    pw.close();
                }
                catch (Throwable throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (IOException io) {
            throw new UncheckedIOException("Problem converting stacktrace to String", io);
        }
    }
}

