/*
 * Decompiled with CFR 0.152.
 */
package net.jworkflow.providers.aws;

import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import net.jworkflow.kernel.interfaces.QueueService;
import net.jworkflow.kernel.models.QueueType;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;

@Singleton
public class SQSQueueService
implements QueueService {
    private final SqsClient sqsClient;
    private final Logger logger = Logger.getLogger(SQSQueueService.class.getName());
    private final String queuePrefix = "jworkflow-";
    private final Map<QueueType, String> queueUrls;
    private final int waitTime = 2;

    public SQSQueueService(Region region) {
        this.sqsClient = (SqsClient)((SqsClientBuilder)SqsClient.builder().region(region)).build();
        this.queueUrls = new HashMap<QueueType, String>();
        this.queueUrls.put(QueueType.WORKFLOW, this.createQueue(QueueType.WORKFLOW));
        this.queueUrls.put(QueueType.EVENT, this.createQueue(QueueType.EVENT));
    }

    public void queueForProcessing(QueueType type, String id) {
        SendMessageRequest request = (SendMessageRequest)SendMessageRequest.builder().queueUrl(this.queueUrls.get(type)).messageBody(id).build();
        this.sqsClient.sendMessage(request);
    }

    public String dequeueForProcessing(QueueType type) {
        ReceiveMessageResponse response = this.sqsClient.receiveMessage(x -> x.maxNumberOfMessages(Integer.valueOf(1)).waitTimeSeconds(Integer.valueOf(2)).queueUrl(this.queueUrls.get(type)));
        Iterator iterator = response.messages().iterator();
        if (iterator.hasNext()) {
            Message msg = (Message)iterator.next();
            this.sqsClient.deleteMessage(x -> x.queueUrl(this.queueUrls.get(type)).receiptHandle(msg.receiptHandle()));
            return msg.body();
        }
        return null;
    }

    public boolean isDequeueBlocking() {
        return true;
    }

    private String createQueue(QueueType type) {
        String queueName = "jworkflow-" + type.toString();
        this.sqsClient.createQueue(builder -> builder.queueName(queueName));
        GetQueueUrlResponse getQueueUrlResponse = this.sqsClient.getQueueUrl(builder -> builder.queueName(queueName));
        return getQueueUrlResponse.queueUrl();
    }
}

