/*
 * Decompiled with CFR 0.152.
 */
package net.jworkflow.providers.aws;

import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.JsonWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.jworkflow.kernel.interfaces.PersistenceService;
import net.jworkflow.kernel.models.Event;
import net.jworkflow.kernel.models.EventSubscription;
import net.jworkflow.kernel.models.WorkflowInstance;
import net.jworkflow.kernel.models.WorkflowStatus;
import net.jworkflow.providers.aws.DynamoDBProvisioner;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.Select;

public class DynamoDBPersistenceService
implements PersistenceService {
    public static final String WORKFLOW_TABLE = "workflows";
    public static final String SUBSCRIPTION_TABLE = "subscriptions";
    public static final String EVENT_TABLE = "events";
    private final String tablePrefix;
    private final DynamoDbClient client;
    private final DynamoDBProvisioner provisioner;

    public DynamoDBPersistenceService(Region region, DynamoDBProvisioner provisioner, String tablePrefix) {
        this.client = (DynamoDbClient)((DynamoDbClientBuilder)DynamoDbClient.builder().region(region)).build();
        this.provisioner = provisioner;
        this.tablePrefix = tablePrefix;
    }

    public String createNewWorkflow(WorkflowInstance workflow) {
        workflow.setId(UUID.randomUUID().toString());
        Map<String, AttributeValue> item = this.mapFromWorkflow(workflow);
        PutItemResponse resp = this.client.putItem(x -> x.tableName(this.tablePrefix + "-" + WORKFLOW_TABLE).conditionExpression("attribute_not_exists(id)").item(item));
        return workflow.getId();
    }

    public void persistWorkflow(WorkflowInstance workflow) {
        Map<String, AttributeValue> item = this.mapFromWorkflow(workflow);
        PutItemResponse resp = this.client.putItem(x -> x.tableName(this.tablePrefix + "-" + WORKFLOW_TABLE).item(item));
    }

    public Iterable<String> getRunnableInstances() {
        ArrayList<String> result = new ArrayList<String>();
        Long now = new Date().getTime();
        HashMap<String, AttributeValue> eav = new HashMap<String, AttributeValue>();
        eav.put(":r", (AttributeValue)AttributeValue.builder().n("1").build());
        eav.put(":effective_date", (AttributeValue)AttributeValue.builder().n(now.toString()).build());
        QueryResponse response = this.client.query(x -> x.tableName(this.tablePrefix + "-" + WORKFLOW_TABLE).indexName("ix_runnable").projectionExpression("id").keyConditionExpression("runnable = :r and next_execution <= :effective_date").scanIndexForward(Boolean.valueOf(true)).expressionAttributeValues(eav));
        response.items().stream().forEach(item -> result.add(((AttributeValue)item.get("id")).s()));
        return result;
    }

    public WorkflowInstance getWorkflowInstance(String id) {
        GetItemResponse response = this.client.getItem(x -> x.tableName(this.tablePrefix + "-" + WORKFLOW_TABLE).key(this.buildIdMap(id)));
        return this.mapToWorkflow(response.item());
    }

    public String createEventSubscription(EventSubscription subscription) {
        subscription.id = UUID.randomUUID().toString();
        Map<String, AttributeValue> item = this.mapFromSubscription(subscription);
        PutItemResponse resp = this.client.putItem(x -> x.tableName(this.tablePrefix + "-" + SUBSCRIPTION_TABLE).conditionExpression("attribute_not_exists(id)").item(item));
        return subscription.id;
    }

    public Iterable<EventSubscription> getSubcriptions(String eventName, String eventKey, Date asOf) {
        ArrayList<EventSubscription> result = new ArrayList<EventSubscription>();
        Long asOfMs = asOf.getTime();
        HashMap<String, AttributeValue> eav = new HashMap<String, AttributeValue>();
        eav.put(":slug", (AttributeValue)AttributeValue.builder().s(eventName + ":" + eventKey).build());
        eav.put(":as_of", (AttributeValue)AttributeValue.builder().n(asOfMs.toString()).build());
        QueryResponse response = this.client.query(x -> x.tableName(this.tablePrefix + "-" + SUBSCRIPTION_TABLE).indexName("ix_slug").select(Select.ALL_PROJECTED_ATTRIBUTES).keyConditionExpression("event_slug = :slug and subscribe_as_of <= :as_of").scanIndexForward(Boolean.valueOf(true)).expressionAttributeValues(eav));
        response.items().stream().forEach(item -> result.add(this.mapToSubscription((Map<String, AttributeValue>)item)));
        return result;
    }

    public void terminateSubscription(String eventSubscriptionId) {
        this.client.deleteItem(x -> x.tableName(this.tablePrefix + "-" + SUBSCRIPTION_TABLE).key(this.buildIdMap(eventSubscriptionId)));
    }

    public String createEvent(Event newEvent) {
        newEvent.id = UUID.randomUUID().toString();
        Map<String, AttributeValue> item = this.mapFromEvent(newEvent);
        PutItemResponse resp = this.client.putItem(x -> x.tableName(this.tablePrefix + "-" + EVENT_TABLE).conditionExpression("attribute_not_exists(id)").item(item));
        return newEvent.id;
    }

    public Event getEvent(String id) {
        GetItemResponse response = this.client.getItem(x -> x.tableName(this.tablePrefix + "-" + EVENT_TABLE).key(this.buildIdMap(id)));
        return this.mapToEvent(response.item());
    }

    public Iterable<String> getRunnableEvents() {
        ArrayList<String> result = new ArrayList<String>();
        Long now = new Date().getTime();
        HashMap<String, AttributeValue> eav = new HashMap<String, AttributeValue>();
        eav.put(":n", (AttributeValue)AttributeValue.builder().n("1").build());
        eav.put(":effective_date", (AttributeValue)AttributeValue.builder().n(now.toString()).build());
        QueryResponse response = this.client.query(x -> x.tableName(this.tablePrefix + "-" + EVENT_TABLE).indexName("ix_not_processed").projectionExpression("id").keyConditionExpression("not_processed = :n and event_time <= :effective_date").scanIndexForward(Boolean.valueOf(true)).expressionAttributeValues(eav));
        response.items().stream().forEach(item -> result.add(((AttributeValue)item.get("id")).s()));
        return result;
    }

    public Iterable<String> getEvents(String eventName, String eventKey, Date asOf) {
        ArrayList<String> result = new ArrayList<String>();
        Long asOfMs = asOf.getTime();
        HashMap<String, AttributeValue> eav = new HashMap<String, AttributeValue>();
        eav.put(":slug", (AttributeValue)AttributeValue.builder().s(eventName + ":" + eventKey).build());
        eav.put(":effective_date", (AttributeValue)AttributeValue.builder().n(asOfMs.toString()).build());
        QueryResponse response = this.client.query(x -> x.tableName(this.tablePrefix + "-" + EVENT_TABLE).indexName("ix_slug").projectionExpression("id").keyConditionExpression("event_slug = :slug and event_time >= :effective_date").scanIndexForward(Boolean.valueOf(true)).expressionAttributeValues(eav));
        response.items().stream().forEach(item -> result.add(((AttributeValue)item.get("id")).s()));
        return result;
    }

    public void markEventProcessed(String id) {
        this.client.updateItem(x -> x.tableName(this.tablePrefix + "-" + EVENT_TABLE).key(this.buildIdMap(id)).updateExpression("REMOVE not_processed"));
    }

    public void markEventUnprocessed(String id) {
        HashMap<String, AttributeValue> eav = new HashMap<String, AttributeValue>();
        eav.put(":n", (AttributeValue)AttributeValue.builder().n("1").build());
        this.client.updateItem(x -> x.tableName(this.tablePrefix + "-" + EVENT_TABLE).key(this.buildIdMap(id)).updateExpression("ADD not_processed = :n").expressionAttributeValues(eav));
    }

    public void provisionStore() {
        this.provisioner.ensureTables();
    }

    private Map<String, AttributeValue> mapFromWorkflow(WorkflowInstance source) {
        HashMap<String, AttributeValue> result = new HashMap<String, AttributeValue>();
        result.put("id", (AttributeValue)AttributeValue.builder().s(source.getId()).build());
        result.put("workflow_status", (AttributeValue)AttributeValue.builder().s(source.getStatus().toString()).build());
        result.put("workflow_definition_id", (AttributeValue)AttributeValue.builder().s(source.getWorkflowDefintionId()).build());
        if (source.getNextExecution() != null) {
            result.put("next_exectution", (AttributeValue)AttributeValue.builder().n(source.getNextExecution().toString()).build());
        }
        if (source.getStatus() == WorkflowStatus.RUNNABLE) {
            result.put("runnable", (AttributeValue)AttributeValue.builder().n("1").build());
        }
        result.put("instance", (AttributeValue)AttributeValue.builder().s(JsonWriter.objectToJson((Object)source)).build());
        return result;
    }

    private WorkflowInstance mapToWorkflow(Map<String, AttributeValue> source) {
        return (WorkflowInstance)JsonReader.jsonToJava((String)source.get("instance").s());
    }

    private Map<String, AttributeValue> mapFromSubscription(EventSubscription source) {
        HashMap<String, AttributeValue> result = new HashMap<String, AttributeValue>();
        result.put("id", (AttributeValue)AttributeValue.builder().s(source.id).build());
        result.put("event_name", (AttributeValue)AttributeValue.builder().s(source.eventName).build());
        result.put("event_key", (AttributeValue)AttributeValue.builder().s(source.eventKey).build());
        result.put("workflow_id", (AttributeValue)AttributeValue.builder().s(source.workflowId).build());
        result.put("step_id", (AttributeValue)AttributeValue.builder().s(String.valueOf(source.stepId)).build());
        result.put("subscribe_as_of", (AttributeValue)AttributeValue.builder().n(String.valueOf(source.subscribeAsOfUtc.getTime())).build());
        result.put("event_slug", (AttributeValue)AttributeValue.builder().s(source.eventName + ":" + source.eventKey).build());
        return result;
    }

    private EventSubscription mapToSubscription(Map<String, AttributeValue> source) {
        EventSubscription result = new EventSubscription();
        result.id = source.get("id").s();
        result.eventName = source.get("event_name").s();
        result.eventKey = source.get("event_key").s();
        result.workflowId = source.get("workflow_id").s();
        result.stepId = Integer.parseInt(source.get("step_id").s());
        Long asOfMs = Long.parseLong(source.get("subscribe_as_of").n());
        result.subscribeAsOfUtc = new Date(asOfMs);
        return result;
    }

    private Map<String, AttributeValue> mapFromEvent(Event source) {
        HashMap<String, AttributeValue> result = new HashMap<String, AttributeValue>();
        result.put("id", (AttributeValue)AttributeValue.builder().s(source.id).build());
        result.put("event_name", (AttributeValue)AttributeValue.builder().s(source.eventName).build());
        result.put("event_key", (AttributeValue)AttributeValue.builder().s(source.eventKey).build());
        result.put("event_data", (AttributeValue)AttributeValue.builder().s(JsonWriter.objectToJson((Object)source.eventData)).build());
        result.put("event_time", (AttributeValue)AttributeValue.builder().n(String.valueOf(source.eventTimeUtc.getTime())).build());
        result.put("event_slug", (AttributeValue)AttributeValue.builder().s(source.eventName + ":" + source.eventKey).build());
        if (!source.isProcessed) {
            result.put("not_processed", (AttributeValue)AttributeValue.builder().n("1").build());
        }
        return result;
    }

    private Event mapToEvent(Map<String, AttributeValue> source) {
        Event result = new Event();
        result.id = source.get("id").s();
        result.eventName = source.get("event_name").s();
        result.eventKey = source.get("event_key").s();
        result.eventData = JsonReader.jsonToJava((String)source.get("event_data").s());
        result.isProcessed = !source.containsKey("not_processed");
        Long asOfMs = Long.parseLong(source.get("event_time").n());
        result.eventTimeUtc = new Date(asOfMs);
        return result;
    }

    private Map<String, AttributeValue> buildIdMap(String id) {
        HashMap<String, AttributeValue> result = new HashMap<String, AttributeValue>();
        result.put("id", (AttributeValue)AttributeValue.builder().s(id).build());
        return result;
    }
}

