/*
 * Decompiled with CFR 0.152.
 */
package net.jworkflow.providers.aws;

import com.google.inject.Singleton;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jworkflow.kernel.interfaces.LockService;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.TableStatus;

@Singleton
public class DynamoDBLockService
implements LockService {
    private final String tableName;
    private final Region region;
    private final String nodeId;
    private DynamoDbClient client;
    private final long ttl = 30000L;
    private final long heartbeat = 10000L;
    private final long jitter = 1000L;
    private final ScheduledExecutorService scheduler;
    private final List<String> localLocks;
    private ScheduledFuture heartbeatFuture;

    public DynamoDBLockService(Region region, String tableName) {
        this.region = region;
        this.tableName = tableName;
        this.nodeId = UUID.randomUUID().toString();
        this.localLocks = new ArrayList<String>();
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
    }

    public boolean acquireLock(String id) {
        if (this.client == null) {
            throw new IllegalStateException();
        }
        Map<String, AttributeValue> item = this.buildIdMap(id);
        item.put("lock_owner", (AttributeValue)AttributeValue.builder().s(this.nodeId).build());
        item.put("expires", (AttributeValue)AttributeValue.builder().n(String.valueOf(Instant.now().toEpochMilli() + 30000L)).build());
        HashMap<String, AttributeValue> condValues = new HashMap<String, AttributeValue>();
        condValues.put(":expired", (AttributeValue)AttributeValue.builder().n(String.valueOf(Instant.now().toEpochMilli() + 1000L)).build());
        try {
            PutItemResponse lock1Resp = this.client.putItem(x -> x.tableName(this.tableName).conditionExpression("attribute_not_exists(id) OR (expires < :expired)").expressionAttributeValues(condValues).item(item));
            if (lock1Resp.sdkHttpResponse().isSuccessful()) {
                this.addToLocal(id);
                return true;
            }
        }
        catch (ConditionalCheckFailedException ex) {
            Logger.getLogger(DynamoDBLockService.class.getName()).log(Level.FINE, "Failed to get lock {0}", id);
        }
        return false;
    }

    public void releaseLock(String id) {
        if (this.client == null) {
            throw new IllegalStateException();
        }
        this.removeFromLocal(id);
        HashMap<String, AttributeValue> cv = new HashMap<String, AttributeValue>();
        cv.put(":nodeId", (AttributeValue)AttributeValue.builder().s(this.nodeId).build());
        try {
            this.client.deleteItem(x -> x.tableName(this.tableName).key(this.buildIdMap(id)).conditionExpression("lock_owner = :nodeId").expressionAttributeValues(cv));
        }
        catch (ConditionalCheckFailedException ex) {
            Logger.getLogger(DynamoDBLockService.class.getName()).log(Level.FINE, "Failed to release lock {0}", id);
        }
    }

    public void start() {
        this.client = (DynamoDbClient)((DynamoDbClientBuilder)DynamoDbClient.builder().region(this.region)).build();
        this.ensureTable();
        this.heartbeatFuture = this.scheduler.scheduleAtFixedRate(() -> this.sendHeartbeat(), 10000L, 10000L, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.heartbeatFuture.cancel(true);
        this.client.close();
    }

    private Map<String, AttributeValue> buildIdMap(String id) {
        HashMap<String, AttributeValue> result = new HashMap<String, AttributeValue>();
        result.put("id", (AttributeValue)AttributeValue.builder().s(id).build());
        return result;
    }

    private synchronized void sendHeartbeat() {
        try {
            for (String lock : this.localLocks) {
                Map<String, AttributeValue> item = this.buildIdMap(lock);
                item.put("lock_owner", (AttributeValue)AttributeValue.builder().s(this.nodeId).build());
                item.put("expires", (AttributeValue)AttributeValue.builder().n(String.valueOf(Instant.now().toEpochMilli() + 30000L)).build());
                HashMap<String, AttributeValue> cv = new HashMap<String, AttributeValue>();
                cv.put(":nodeId", (AttributeValue)AttributeValue.builder().s(this.nodeId).build());
                try {
                    this.client.putItem(x -> x.tableName(this.tableName).conditionExpression("lock_owner = :nodeId").expressionAttributeValues(cv).item(item));
                }
                catch (ConditionalCheckFailedException ex) {
                    Logger.getLogger(DynamoDBLockService.class.getName()).log(Level.WARNING, "Sent heartbeat for lock that is no longer owned " + lock, ex);
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(DynamoDBLockService.class.getName()).log(Level.WARNING, "Error sending heartbeat", ex);
        }
    }

    private synchronized void addToLocal(String id) {
        this.localLocks.add(id);
    }

    private synchronized void removeFromLocal(String id) {
        this.localLocks.remove(id);
    }

    private void ensureTable() {
        if (this.client == null) {
            throw new IllegalStateException();
        }
        try {
            DescribeTableResponse describeTableResponse = this.client.describeTable(x -> x.tableName(this.tableName));
        }
        catch (ResourceNotFoundException ex) {
            this.createTable();
        }
    }

    private void createTable() throws AwsServiceException, SdkClientException {
        if (this.client == null) {
            throw new IllegalStateException();
        }
        Logger.getLogger(DynamoDBLockService.class.getName()).log(Level.INFO, "Creating lock table in DynamoDB");
        this.client.createTable(x -> x.tableName(this.tableName).billingMode(BillingMode.PAY_PER_REQUEST).keySchema(new Consumer[]{key -> key.attributeName("id").keyType(KeyType.HASH)}).attributeDefinitions(new Consumer[]{attr -> attr.attributeName("id").attributeType("S")}));
        boolean created = false;
        try {
            for (int i = 0; i < 10 && !created; ++i) {
                Thread.sleep(1000L);
                DescribeTableResponse r = this.client.describeTable(x -> x.tableName(this.tableName));
                created = r.table().tableStatus() == TableStatus.ACTIVE;
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DynamoDBLockService.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

