/*
 * Decompiled with CFR 0.152.
 */
package net.jworkflow.providers.aws;

import java.util.Arrays;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jworkflow.providers.aws.DynamoDBLockService;
import net.jworkflow.providers.aws.DynamoDBProvisioner;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.ProjectionType;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.services.dynamodb.model.TableStatus;

public class DefaultDynamoDBProvisioner
implements DynamoDBProvisioner {
    private final DynamoDbClient client;
    private final String prefix;
    private final ProvisionedThroughput defaultThroughput;

    public DefaultDynamoDBProvisioner(Region region, String prefix) {
        this.client = (DynamoDbClient)((DynamoDbClientBuilder)DynamoDbClient.builder().region(region)).build();
        this.defaultThroughput = (ProvisionedThroughput)ProvisionedThroughput.builder().readCapacityUnits(Long.valueOf(1L)).writeCapacityUnits(Long.valueOf(1L)).build();
        this.prefix = prefix;
    }

    @Override
    public void ensureTables() throws AwsServiceException, SdkClientException {
        Future task1 = ForkJoinPool.commonPool().submit(() -> {
            if (!this.tableExists(this.prefix + "-" + "workflows")) {
                this.createTable(this.buildWorkflowTableRequest());
            }
        });
        Future task2 = ForkJoinPool.commonPool().submit(() -> {
            if (!this.tableExists(this.prefix + "-" + "subscriptions")) {
                this.createTable(this.buildSubscriptionTableRequest());
            }
        });
        Future task3 = ForkJoinPool.commonPool().submit(() -> {
            if (!this.tableExists(this.prefix + "-" + "events")) {
                this.createTable(this.buildEventTableRequest());
            }
        });
        ((ForkJoinTask)task1).join();
        ((ForkJoinTask)task2).join();
        ((ForkJoinTask)task3).join();
    }

    private CreateTableRequest buildWorkflowTableRequest() {
        GlobalSecondaryIndex runnableIx = (GlobalSecondaryIndex)GlobalSecondaryIndex.builder().indexName("ix_runnable").keySchema(Arrays.asList((KeySchemaElement)KeySchemaElement.builder().attributeName("runnable").keyType(KeyType.HASH).build(), (KeySchemaElement)KeySchemaElement.builder().attributeName("next_execution").keyType(KeyType.RANGE).build())).projection(x -> x.projectionType(ProjectionType.KEYS_ONLY)).build();
        return (CreateTableRequest)CreateTableRequest.builder().tableName(this.prefix + "-" + "workflows").billingMode(BillingMode.PAY_PER_REQUEST).keySchema(new Consumer[]{key -> key.attributeName("id").keyType(KeyType.HASH)}).attributeDefinitions(Arrays.asList((AttributeDefinition)AttributeDefinition.builder().attributeName("id").attributeType(ScalarAttributeType.S).build(), (AttributeDefinition)AttributeDefinition.builder().attributeName("runnable").attributeType(ScalarAttributeType.N).build(), (AttributeDefinition)AttributeDefinition.builder().attributeName("next_execution").attributeType(ScalarAttributeType.N).build())).globalSecondaryIndexes(new GlobalSecondaryIndex[]{runnableIx}).build();
    }

    private CreateTableRequest buildSubscriptionTableRequest() {
        GlobalSecondaryIndex slugIx = (GlobalSecondaryIndex)GlobalSecondaryIndex.builder().indexName("ix_slug").keySchema(Arrays.asList((KeySchemaElement)KeySchemaElement.builder().attributeName("event_slug").keyType(KeyType.HASH).build(), (KeySchemaElement)KeySchemaElement.builder().attributeName("subscribe_as_of").keyType(KeyType.RANGE).build())).projection(x -> x.projectionType(ProjectionType.ALL)).build();
        return (CreateTableRequest)CreateTableRequest.builder().tableName(this.prefix + "-" + "subscriptions").billingMode(BillingMode.PAY_PER_REQUEST).keySchema(new Consumer[]{key -> key.attributeName("id").keyType(KeyType.HASH)}).attributeDefinitions(Arrays.asList((AttributeDefinition)AttributeDefinition.builder().attributeName("id").attributeType(ScalarAttributeType.S).build(), (AttributeDefinition)AttributeDefinition.builder().attributeName("event_slug").attributeType(ScalarAttributeType.S).build(), (AttributeDefinition)AttributeDefinition.builder().attributeName("subscribe_as_of").attributeType(ScalarAttributeType.N).build())).globalSecondaryIndexes(new GlobalSecondaryIndex[]{slugIx}).build();
    }

    private CreateTableRequest buildEventTableRequest() {
        GlobalSecondaryIndex slugIx = (GlobalSecondaryIndex)GlobalSecondaryIndex.builder().indexName("ix_slug").keySchema(Arrays.asList((KeySchemaElement)KeySchemaElement.builder().attributeName("event_slug").keyType(KeyType.HASH).build(), (KeySchemaElement)KeySchemaElement.builder().attributeName("event_time").keyType(KeyType.RANGE).build())).projection(x -> x.projectionType(ProjectionType.KEYS_ONLY)).build();
        GlobalSecondaryIndex processedIx = (GlobalSecondaryIndex)GlobalSecondaryIndex.builder().indexName("ix_not_processed").keySchema(Arrays.asList((KeySchemaElement)KeySchemaElement.builder().attributeName("not_processed").keyType(KeyType.HASH).build(), (KeySchemaElement)KeySchemaElement.builder().attributeName("event_time").keyType(KeyType.RANGE).build())).projection(x -> x.projectionType(ProjectionType.KEYS_ONLY)).build();
        return (CreateTableRequest)CreateTableRequest.builder().tableName(this.prefix + "-" + "events").billingMode(BillingMode.PAY_PER_REQUEST).keySchema(new Consumer[]{key -> key.attributeName("id").keyType(KeyType.HASH)}).attributeDefinitions(Arrays.asList((AttributeDefinition)AttributeDefinition.builder().attributeName("id").attributeType(ScalarAttributeType.S).build(), (AttributeDefinition)AttributeDefinition.builder().attributeName("event_slug").attributeType(ScalarAttributeType.S).build(), (AttributeDefinition)AttributeDefinition.builder().attributeName("event_time").attributeType(ScalarAttributeType.N).build(), (AttributeDefinition)AttributeDefinition.builder().attributeName("not_processed").attributeType(ScalarAttributeType.N).build())).globalSecondaryIndexes(Arrays.asList(slugIx, processedIx)).build();
    }

    private void createTable(CreateTableRequest request) throws AwsServiceException, SdkClientException {
        if (this.client == null) {
            throw new IllegalStateException();
        }
        Logger.getLogger(DynamoDBLockService.class.getName()).log(Level.INFO, "Creating {0} table in DynamoDB", request.tableName());
        this.client.createTable(request);
        boolean created = false;
        for (int i = 0; i < 20 && !created; ++i) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DynamoDBLockService.class.getName()).log(Level.SEVERE, null, ex);
            }
            DescribeTableResponse r = this.client.describeTable(x -> x.tableName(request.tableName()));
            created = r.table().tableStatus() == TableStatus.ACTIVE;
        }
    }

    private boolean tableExists(String tableName) {
        if (this.client == null) {
            throw new IllegalStateException();
        }
        try {
            DescribeTableResponse describeTableResponse = this.client.describeTable(x -> x.tableName(tableName));
        }
        catch (ResourceNotFoundException ex) {
            return false;
        }
        return true;
    }
}

