package net.jrouter.http.servlet;

import lombok.Setter;
import net.jrouter.ActionInvocation;
import net.jrouter.impl.ResultTypeProxy;
import net.jrouter.util.MethodUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Collections;
import java.util.Map;

/**
 * 提供非{@code String}类型的结果类型处理;
 * <p>
 * 及可配置的类型{@code Class} - 结果类型{@link ResultTypeProxy}映射。
 */
@Setter
public class ObjectHandlerActionFactory extends ServletActionFactory.DefaultServletActionFactory {

    /**
     * LOG.
     */
    private static final Logger LOG = LoggerFactory.getLogger(ObjectHandlerActionFactory.class);

    /**
     * Object class to ResultType mapping.
     * <p>
     * 完全类型匹配，不考虑父子类继承等。
     */
    private Map<Class<?>, ResultTypeProxy> objectResultTypes = Collections.emptyMap();

    /**
     * Constructor.
     * @param properties Properties
     */
    public ObjectHandlerActionFactory(Properties properties) {
        super(properties);
    }

    @Override
    protected Object invokeResult(ActionInvocation invocation, Object res) {
        ResultTypeProxy resultType = null;
        // 优先根据结果对象的类型获取处理类型
        if (res != null && (resultType = objectResultTypes.get(res.getClass())) != null) {
            return MethodUtil.invokeConvertParameters(resultType, invocation);
        }
        return super.invokeResult(invocation, res);
    }

}
