/*
 * Decompiled with CFR 0.152.
 */
package net.jrouter.http.servlet;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.jrouter.ActionFactory;
import net.jrouter.ActionInvocation;
import net.jrouter.JRouterException;
import net.jrouter.PathGenerator;
import net.jrouter.http.servlet.RequestMap;
import net.jrouter.http.servlet.ServletActionInvocation;
import net.jrouter.http.servlet.ServletThreadContext;
import net.jrouter.impl.PathActionFactory;
import net.jrouter.support.ActionInvocationDelegate;

public interface ServletActionFactory
extends ActionFactory<String> {
    public <T> T invokeAction(String var1, HttpServletRequest var2, HttpServletResponse var3, ServletContext var4) throws JRouterException;

    public static class DefaultServletActionInvocation
    extends ActionInvocationDelegate<String>
    implements ServletActionInvocation {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final RequestMap requestMap;
        private final ServletContext servletContext;
        private final Map<String, Object> contextMap;

        public DefaultServletActionInvocation(ActionInvocation<String> invocation, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, Map<String, Object> contextMap) {
            this.delegate = invocation;
            this.request = request;
            this.requestMap = new RequestMap(request);
            this.response = response;
            this.servletContext = servletContext;
            this.contextMap = contextMap;
            this.setConvertParameters(new Object[]{this});
        }

        @Override
        public HttpServletRequest getRequest() {
            return this.request;
        }

        @Override
        public HttpSession getSession() {
            return this.getRequest().getSession();
        }

        @Override
        public Map<String, String[]> getRequestParameters() {
            return this.requestMap;
        }

        @Override
        public HttpServletResponse getResponse() {
            return this.response;
        }

        @Override
        public ServletContext getServletContext() {
            return this.servletContext;
        }

        @Override
        public Map<String, Object> getContextMap() {
            return this.contextMap;
        }
    }

    public static class DefaultServletActionFactory
    extends PathActionFactory.ColonString
    implements ServletActionFactory {
        private final boolean useThreadLocal;
        private final boolean actionPathCaseSensitive;

        public DefaultServletActionFactory(Properties properties) {
            super((PathActionFactory.ColonString.Properties)properties);
            this.useThreadLocal = properties.useThreadLocal;
            this.actionPathCaseSensitive = properties.actionPathCaseSensitive;
        }

        @Override
        public <T> T invokeAction(String path, HttpServletRequest request, HttpServletResponse response, ServletContext sc) throws JRouterException {
            return (T)super.invokeAction(this.actionPathCaseSensitive ? path : path.toLowerCase(Locale.getDefault()), new Object[]{request, response, sc});
        }

        protected ActionInvocation<String> createActionInvocation(String path, Object ... params) {
            ActionInvocation invocation = super.createActionInvocation(path, params);
            DefaultServletActionInvocation servletInvocation = null;
            if (this.checkHttpParameters(params)) {
                servletInvocation = new DefaultServletActionInvocation((ActionInvocation<String>)invocation, (HttpServletRequest)params[0], (HttpServletResponse)params[1], (ServletContext)params[2], ServletThreadContext.getContextMap());
            }
            if (servletInvocation == null && this.useThreadLocal) {
                servletInvocation = new DefaultServletActionInvocation((ActionInvocation<String>)invocation, ServletThreadContext.getRequest(), ServletThreadContext.getResponse(), ServletThreadContext.getServletContext(), ServletThreadContext.getContextMap());
            }
            if (this.useThreadLocal) {
                ServletThreadContext.setActionInvocation(servletInvocation);
            }
            if (servletInvocation != null) {
                return servletInvocation;
            }
            return invocation;
        }

        private boolean checkHttpParameters(Object ... params) {
            return params != null && params.length == 3 && params[0] instanceof HttpServletRequest && params[1] instanceof HttpServletResponse && params[2] instanceof ServletContext;
        }

        public boolean isUseThreadLocal() {
            return this.useThreadLocal;
        }

        public boolean isActionPathCaseSensitive() {
            return this.actionPathCaseSensitive;
        }

        public static class Properties
        extends PathActionFactory.ColonString.Properties {
            private boolean useThreadLocal = true;
            private boolean actionPathCaseSensitive = true;

            protected void afterPropertiesSet() {
                if (this.getPathGenerator() == null) {
                    PathActionFactory.StringPathGenerator pathGenerator = new PathActionFactory.StringPathGenerator(this.getPathSeparator()){

                        protected String buildActionPath(String namespace, String aname, Method method) {
                            String path = super.buildActionPath(namespace, aname, method);
                            return actionPathCaseSensitive ? path : path.toLowerCase(Locale.getDefault());
                        }
                    };
                    this.setPathGenerator((PathGenerator)pathGenerator);
                }
                super.afterPropertiesSet();
            }

            public boolean isUseThreadLocal() {
                return this.useThreadLocal;
            }

            public boolean isActionPathCaseSensitive() {
                return this.actionPathCaseSensitive;
            }

            public void setUseThreadLocal(boolean useThreadLocal) {
                this.useThreadLocal = useThreadLocal;
            }

            public void setActionPathCaseSensitive(boolean actionPathCaseSensitive) {
                this.actionPathCaseSensitive = actionPathCaseSensitive;
            }
        }
    }
}

