/*
 * Decompiled with CFR 0.152.
 */
package net.jrouter.http.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.jrouter.ActionFactory;
import net.jrouter.ActionInvocation;
import net.jrouter.JRouterException;
import net.jrouter.PathGenerator;
import net.jrouter.http.netty.HttpActionInvocation;
import net.jrouter.impl.PathActionFactory;
import net.jrouter.support.ActionInvocationDelegate;

public interface HttpServerActionFactory
extends ActionFactory<String> {
    public <T> T invokeAction(String var1, FullHttpRequest var2, FullHttpResponse var3, ChannelHandlerContext var4) throws JRouterException;

    public static class DefaultHttpActionInvocation
    extends ActionInvocationDelegate<String>
    implements HttpActionInvocation {
        private final FullHttpRequest request;
        private final FullHttpResponse response;
        private final ChannelHandlerContext channelHandlerContext;
        private final Map<String, Object> contextMap;

        public DefaultHttpActionInvocation(ActionInvocation<String> invocation, FullHttpRequest request, FullHttpResponse response, ChannelHandlerContext channelHandlerContext, Map<String, Object> contextMap) {
            this.delegate = invocation;
            this.request = request;
            this.response = response;
            this.channelHandlerContext = channelHandlerContext;
            this.contextMap = contextMap;
            this.setConvertParameters(new Object[]{this});
        }

        @Override
        public FullHttpRequest getRequest() {
            return this.request;
        }

        @Override
        public FullHttpResponse getResponse() {
            return this.response;
        }

        @Override
        public ChannelHandlerContext getChannelHandlerContext() {
            return this.channelHandlerContext;
        }

        @Override
        public Map<String, Object> getContextMap() {
            return this.contextMap;
        }
    }

    public static class DefaultHttpActionFactory
    extends PathActionFactory
    implements HttpServerActionFactory {
        private final boolean actionPathCaseSensitive;

        public DefaultHttpActionFactory(Properties properties) {
            super((PathActionFactory.Properties)properties);
            this.actionPathCaseSensitive = properties.actionPathCaseSensitive;
        }

        @Override
        public <T> T invokeAction(String path, FullHttpRequest request, FullHttpResponse response, ChannelHandlerContext sc) throws JRouterException {
            return (T)super.invokeAction(this.actionPathCaseSensitive ? path : path.toLowerCase(Locale.getDefault()), new Object[]{request, response, sc});
        }

        protected ActionInvocation<String> createActionInvocation(String path, Object ... params) {
            ActionInvocation invocation = super.createActionInvocation(path, params);
            DefaultHttpActionInvocation httpInvocation = null;
            if (this.checkHttpParameters(params)) {
                httpInvocation = new DefaultHttpActionInvocation((ActionInvocation<String>)invocation, (FullHttpRequest)params[0], (FullHttpResponse)params[1], (ChannelHandlerContext)params[2], new HashMap<String, Object>(4));
                return httpInvocation;
            }
            return invocation;
        }

        private boolean checkHttpParameters(Object ... params) {
            return params != null && params.length == 3 && params[0] instanceof FullHttpRequest && params[1] instanceof FullHttpResponse && params[2] instanceof ChannelHandlerContext;
        }

        public boolean isActionPathCaseSensitive() {
            return this.actionPathCaseSensitive;
        }

        public static class Properties
        extends PathActionFactory.ColonString.Properties {
            private boolean actionPathCaseSensitive = true;

            protected void afterPropertiesSet() {
                if (this.getPathGenerator() == null) {
                    PathActionFactory.StringPathGenerator pathGenerator = new PathActionFactory.StringPathGenerator(this.getPathSeparator()){

                        protected String buildActionPath(String namespace, String aname, Method method) {
                            String path = super.buildActionPath(namespace, aname, method);
                            return actionPathCaseSensitive ? path : path.toLowerCase(Locale.getDefault());
                        }
                    };
                    this.setPathGenerator((PathGenerator)pathGenerator);
                }
                super.afterPropertiesSet();
            }

            public boolean isActionPathCaseSensitive() {
                return this.actionPathCaseSensitive;
            }

            public void setActionPathCaseSensitive(boolean actionPathCaseSensitive) {
                this.actionPathCaseSensitive = actionPathCaseSensitive;
            }
        }
    }
}

