/*
 * Decompiled with CFR 0.152.
 */
package net.jrouter.http.netty;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelProgressiveFuture;
import io.netty.channel.ChannelProgressiveFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Objects;
import java.util.function.BiPredicate;
import lombok.NonNull;
import net.jrouter.NotFoundException;
import net.jrouter.http.netty.HttpServerActionFactory;
import net.jrouter.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JRouterHttpRequestHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(JRouterHttpRequestHandler.class);
    public static final char PATH_SEPARATOR = '/';
    private static final String PATH_SEPARATOR_STRING = String.valueOf('/');
    private final HttpServerActionFactory httpServerActionFactory;
    private String contextPath;
    private boolean logNotFoundException = true;
    @NonNull
    private BiPredicate<ChannelHandlerContext, FullHttpRequest> httpRequestPredicate = (channelHandlerContext, fullHttpRequest) -> true;

    public JRouterHttpRequestHandler(HttpServerActionFactory httpServerActionFactory) {
        Objects.requireNonNull(httpServerActionFactory, "httpServerActionFactory can't be null");
        this.httpServerActionFactory = httpServerActionFactory;
    }

    private static String parseActionPath(String uri) {
        int end;
        if (StringUtil.isEmpty((CharSequence)uri)) {
            return uri;
        }
        int start = 0;
        if (uri.charAt(0) != '/') {
            int idx = uri.indexOf("://");
            if (idx > -1) {
                int sepIdx = uri.indexOf(47, idx + 3);
                if (sepIdx == -1) {
                    return PATH_SEPARATOR_STRING;
                }
                start = sepIdx;
            } else {
                uri = '/' + uri;
            }
        }
        return (end = JRouterHttpRequestHandler.findPathEndIndex(uri)) > -1 ? uri.substring(start, end) : uri.substring(start);
    }

    private static int findPathEndIndex(String uri) {
        int len = uri.length();
        for (int i = 0; i < len; ++i) {
            char c = uri.charAt(i);
            if (c != '?' && c != '#') continue;
            return i;
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        block12: {
            if (!(msg instanceof FullHttpRequest) || !this.httpRequestPredicate.test(ctx, fullHttpRequest = (FullHttpRequest)msg)) break block12;
            try {
                fullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
                uri = fullHttpRequest.uri();
                res = null;
                try {
                    actionPath = JRouterHttpRequestHandler.parseActionPath(uri);
                    if (!StringUtil.isNotBlank((CharSequence)this.contextPath) || JRouterHttpRequestHandler.PATH_SEPARATOR_STRING.equals(this.contextPath)) ** GOTO lbl15
                    if (!actionPath.startsWith(this.contextPath + '/')) {
                        JRouterHttpRequestHandler.log.warn("Uri not matched [{}] : {}", (Object)this.contextPath, (Object)actionPath);
                        fullHttpResponse.setStatus(HttpResponseStatus.NOT_FOUND);
                    } else {
                        actionPath = actionPath.substring(this.contextPath.length());
lbl15:
                        // 2 sources

                        res = this.httpServerActionFactory.invokeAction(actionPath, fullHttpRequest, (FullHttpResponse)fullHttpResponse, ctx);
                    }
                }
                catch (NotFoundException e) {
                    if (this.logNotFoundException) {
                        JRouterHttpRequestHandler.log.error("Not Found : {}", (Object)uri, (Object)e);
                    }
                    fullHttpResponse.setStatus(HttpResponseStatus.NOT_FOUND);
                }
                catch (Exception e) {
                    JRouterHttpRequestHandler.log.error("Internal Server Error : {}", (Object)uri, (Object)e);
                    fullHttpResponse.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
                }
                if (res instanceof FullHttpResponse) {
                    this.writeHttpResponse(ctx, fullHttpRequest, res);
                }
                if (res instanceof HttpChunkedInput) {
                    response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, fullHttpResponse.headers());
                    HttpUtil.setTransferEncodingChunked((HttpMessage)response, (boolean)true);
                    ctx.write((Object)response);
                    lastContentFuture = ctx.writeAndFlush((Object)res, (ChannelPromise)ctx.newProgressivePromise());
                    if (JRouterHttpRequestHandler.log.isDebugEnabled()) {
                        lastContentFuture.addListener((GenericFutureListener)new ChannelProgressiveFutureListener(){

                            public void operationProgressed(ChannelProgressiveFuture future, long progress, long total) {
                                if (log.isDebugEnabled()) {
                                    log.debug(future.channel() + " Transfer progress: " + progress + " / " + total);
                                }
                            }

                            public void operationComplete(ChannelProgressiveFuture future) {
                                if (log.isDebugEnabled()) {
                                    log.debug(future.channel() + " Transfer complete.");
                                }
                            }
                        });
                    }
                    if (HttpUtil.isKeepAlive((HttpMessage)fullHttpRequest)) ** GOTO lbl52
                    lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
                this.writeHttpResponse(ctx, fullHttpRequest, (FullHttpResponse)fullHttpResponse, res);
            }
            finally {
                ReferenceCountUtil.release((Object)msg);
            }
        }
        ctx.fireChannelRead(msg);
lbl52:
        // 5 sources

    }

    protected void writeHttpResponse(ChannelHandlerContext ctx, FullHttpRequest request, FullHttpResponse response) {
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
        HttpUtil.setContentLength((HttpMessage)response, (long)response.content().readableBytes());
        HttpUtil.setKeepAlive((HttpMessage)response, (boolean)keepAlive);
        ChannelFuture channelFuture = ctx.writeAndFlush((Object)response);
        if (!keepAlive) {
            channelFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    protected void writeHttpResponse(ChannelHandlerContext ctx, FullHttpRequest request, FullHttpResponse response, Object invokedRes) {
        this.writeHttpResponse(ctx, request, response);
    }

    public void setContextPath(String contextPath) {
        if (StringUtil.isNotEmpty((CharSequence)contextPath)) {
            if (contextPath.charAt(0) != '/') {
                contextPath = '/' + contextPath;
            }
            if (contextPath.length() > 1 && '/' == contextPath.charAt(contextPath.length() - 1)) {
                contextPath = contextPath.substring(0, contextPath.length() - 1);
            }
        }
        this.contextPath = contextPath;
    }

    public HttpServerActionFactory getHttpServerActionFactory() {
        return this.httpServerActionFactory;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public boolean isLogNotFoundException() {
        return this.logNotFoundException;
    }

    public void setLogNotFoundException(boolean logNotFoundException) {
        this.logNotFoundException = logNotFoundException;
    }

    public void setHttpRequestPredicate(@NonNull BiPredicate<ChannelHandlerContext, FullHttpRequest> httpRequestPredicate) {
        if (httpRequestPredicate == null) {
            throw new NullPointerException("httpRequestPredicate is marked @NonNull but is null");
        }
        this.httpRequestPredicate = httpRequestPredicate;
    }
}

